/* ************************************************************************
*   File: races.c                                  Extension of CircleMUD *
*  Usage: Source file for race-specific code                              *
* Author: Brian Williams <bmw@efn.org>                                    *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Copyright (C) 1993, 94 by the Trustees of the Johns Hopkins University *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
************************************************************************ */

#include "conf.h"
#include "sysdep.h"


#include "structs.h"
#include "db.h"
#include "utils.h"
#include "spells.h"
#include "interpreter.h"

/* Local functions */
const char *race_abbrevs[];
const char *pc_race_types[];
const char *race_menu;
int parse_race(char arg);
long find_race_bitvector(char arg);
int invalid_race(struct char_data *ch, struct obj_data *obj);

const char *race_abbrevs[] = {
  "Hum",
  "Elf",
  "Gno",
  "Dwa",
  "Hob",
  "\n"
};


const char *pc_race_types[] = {
  "Human",
  "Elf",
  "Gnome",
  "Dwarf",
  "Hobbit",
  "\n"
};


const char *race_menu =
"\r\n"
"Select a race:\r\n"
"  1) Human\r\n"
"  2) Elf\r\n"
"  3) Gnome\r\n"
"  4) Dwarf\r\n"
"  5) Hobbit\r\n";


int parse_race(char arg)
{
  switch (arg) {
    case '1': return RACE_HUMAN;
    case '2': return RACE_ELF;
    case '3': return RACE_GNOME;
    case '4': return RACE_DWARF;
    case '5': return RACE_HOBBIT;
    default : return RACE_UNDEFINED;
  }
}


long find_race_bitvector(char arg)
{
  switch (arg) {
    case '1': return (1 << RACE_HUMAN);
    case '2': return (1 << RACE_ELF);
    case '3': return (1 << RACE_GNOME);
    case '4': return (1 << RACE_DWARF);
    case '5': return (1 << RACE_HOBBIT);
    default : return (0);
  }
}


int invalid_race(struct char_data *ch, struct obj_data *obj)
{
  if ((OBJ_FLAGGED(obj, ITEM_ANTI_HUMAN) && IS_HUMAN(ch)) ||
      (OBJ_FLAGGED(obj, ITEM_ANTI_ELF) && IS_ELF(ch)) ||
      (OBJ_FLAGGED(obj, ITEM_ANTI_GNOME) && IS_GNOME(ch)) ||
      (OBJ_FLAGGED(obj, ITEM_ANTI_DWARF) && IS_DWARF(ch)) ||
      (OBJ_FLAGGED(obj, ITEM_ANTI_HOBBIT) && IS_HOBBIT(ch)))
    return (1);
  else
    return (0);
}