/* ************************************************************************
*  File: editor.h                                Part of Death's Gate MUD *
*                                                                         *
*  Usage: stuff used by the string editing system                         *
*                                                                         *
*  All rights reserved.  See license.doc for complete information.        *
*                                                                         *
*  Death's Gate MUD is based on CircleMUD, Copyright (C) 1993, 94.        *
*  CircleMUD is based on DikuMUD, Copyright (C) 1990, 1991.               *
*                                                                         *
*  $Author: danielh $
*  $Date: 1997/09/27 01:26:47 $
*  $Revision: 1.8 $
************************************************************************ */


/* functions */
void string_edit(struct descriptor_data *d, char *str, size_t size,
		 EDITFUNC(*func), void *obj, byte append);
void string_add(struct descriptor_data *d, char *str);
void string_finish(struct descriptor_data *d, int terminator);


/* various structs used by finishing functions */
struct finish_board_data {
  char *heading;		/* message of heading */
  int board;			/* board edited on    */
};

struct finish_note_data {
  sstring **desc;	        /* act-desc of paper */
  long id;			/* uid of object     */
};

struct finish_olcstr_data {
  char **string;		/* string being edited */
  int  mode;			/* editing mode        */
  int  target;			/* editing target      */
  void *ptr;			/* ptr to verify targ  */
};

struct finish_olcshr_data {
  sstring **string;		/* sstring being edited */
  int     mode;			/* editing mode         */
  int     target;		/* editing target       */
  void    *ptr;			/* ptr to verify target */
};

struct finish_olcdoor_data {
  char **string;		/* string being edited */
  int  target;			/* room edited         */
  int  door;			/* door edited         */
  void *ptr;			/* ptr of dir_option   */
};

struct finish_olcextr_data {
  sstring **string;		/* string being edited */
  int     target;		/* target edited       */
  int     mode;			/* olc mode            */
  void    *ptr;			/* extra descr         */
};


EDITFUNC(finish_mail);
EDITFUNC(finish_desc);
EDITFUNC(finish_board);
EDITFUNC(finish_note);
EDITFUNC(finish_olc_string);
EDITFUNC(finish_olc_sstring);
EDITFUNC(finish_olc_door);
EDITFUNC(finish_olc_exdesc);
EDITFUNC(finish_olc_farg);

/* misc editor defines **************************************************/

/* format modes for format_text */
#define FORMAT_INDENT		(1 << 0)

