/************************************************************************
 * OasisOLC - medit.c						v1.5	*
 * Copyright 1996 Harvey Gilpin.					*
 ************************************************************************/

#include "conf.h"
#include "sysdep.h"

#include "structs.h"
#include "scripts.h"
#include "index.h"
#include "comm.h"
#include "spells.h"
#include "utils.h"
#include "db.h"
#include "olc.h"
#include "constants.h"
#include "events.h"
#include "spec.h"

/*
 * Set this to 1 for debugging logs in medit_save_internally.
 */
#if 0
#define DEBUG
#endif

/*
 * Set this to 1 as a last resort to save mobiles.
 */
#if 0
#define I_CRASH
#endif

/*-------------------------------------------------------------------*/

/*
 * External variable declarations.
 */
// extern struct index_data *mob_index;
// extern struct char_data *mob_proto;
// extern struct char_data *character_list;
// extern int top_of_mobt;
// extern struct zone_data *zone_table;
// extern int top_of_zone_table;
// extern struct player_special_data dummy_mob;
// extern struct attack_hit_type attack_hit_text[];
// extern char *action_bits[];
// extern char *affected_bits[];
// extern char *position_types[];
// extern char *genders[];
// extern int top_shop;
// extern struct shop_data *shop_index;
// extern struct descriptor_data *descriptor_list;
extern char *spells[];

/*-------------------------------------------------------------------*/

/*
 * Handy internal macros.
 */

#define GET_ALIAS(mob) ((mob)->player.name)
#define GET_SDESC(mob) ((mob)->player.short_descr)
#define GET_LDESC(mob) ((mob)->player.long_descr)
#define GET_DDESC(mob) ((mob)->player.description)
#define S_KEEPER(shop) ((shop)->keeper)
#define PROTO_MOB(num) ((char_data *) mob_index[(num)]->proto)

/*-------------------------------------------------------------------*/

/*
 * Function prototypes.
 */
void medit_parse(char_data *ch, char *arg);
void medit_disp_menu(char_data *ch);
void medit_disp_extended_menu(char_data *ch);
void medit_setup_new(char_data *ch, int copyfrom);
void medit_setup_existing(char_data *ch, int copyfrom);
void medit_save_internally(char_data *ch);
void init_mobile(struct char_data *mob);
void copy_mobile(struct char_data *tmob, struct char_data *fmob);
void medit_disp_positions(char_data *ch);
void medit_disp_flags(char_data *ch);
void medit_disp_attack_types(char_data *ch);

extern void olc_disp_specproc_menu(char_data *ch);
extern void olc_edit_special(char_data *ch, char *argument);

/*-------------------------------------------------------------------*\
  utility functions 
\*-------------------------------------------------------------------*/

void medit_setup_new(char_data *ch, int copyfrom)
{
  extern void init_mob_proto(char_data *mob);

  if (!copyfrom) {
    OLC_MOB(ch) = new char_data;
    init_mob_proto(OLC_MOB(ch));
    OLC_SAVE(ch) = OLC_SAVE_NO;
  } else {
    OLC_MOB(ch) = new char_data;
    OLC_MOB(ch)->copyover(PROTO_MOB(copyfrom));
    OLC_SCRIPT(ch) = new script_data;
    OLC_SCRIPT(ch)->copyintlist(mob_index[copyfrom]->triggers);
    OLC_SAVE(ch) = OLC_SAVE_COPY;
  }

  GET_MOB_NUM(OLC_MOB(ch)) = OLC_NUM(ch);
  medit_disp_menu(ch);
}

/*-------------------------------------------------------------------*/

void medit_setup_existing(char_data *ch, int copyfrom)
{   
  if (!copyfrom) {
    OLC_MOB(ch) = new char_data(PROTO_MOB(OLC_NUM(ch)));
    OLC_SCRIPT(ch) = new script_data;
    OLC_SCRIPT(ch)->copyintlist(mob_index[OLC_NUM(ch)]->triggers);
    OLC_SAVE(ch) = OLC_SAVE_NO;
  } else {
    OLC_MOB(ch) = new char_data;
    OLC_MOB(ch)->copyover(PROTO_MOB(copyfrom));
    OLC_SCRIPT(ch) = new script_data;
    OLC_SCRIPT(ch)->copyintlist(mob_index[copyfrom]->triggers);
    OLC_SAVE(ch) = OLC_SAVE_OVERWRITE;
  }

  GET_POINTS_EVENT(OLC_MOB(ch), 0) = NULL;
  GET_POINTS_EVENT(OLC_MOB(ch), 1) = NULL;
  GET_POINTS_EVENT(OLC_MOB(ch), 2) = NULL;
  GET_POINTS_EVENT(OLC_MOB(ch), 3) = NULL;
  GET_ACTION(OLC_MOB(ch)) = NULL;
  GET_DAMAGE_EVENTS(OLC_MOB(ch)) = NULL;

  GET_MOB_NUM(OLC_MOB(ch)) = OLC_NUM(ch);

  medit_disp_menu(ch);
}

/*-------------------------------------------------------------------*/

#define ZCMD zone_table[zone].cmd[cmd_no]

/*
 * Save new/edited mob to memory.
 */
void medit_save_internally(char_data *ch)
{
//   int i, shop, robj_num, found = FALSE, zone, cmd_no;
//   struct extra_descr_data *this, *next_one;
//   struct obj_data *obj, *swap, *new_obj_proto;
//   struct index_data *new_obj_index;
//  char_data *chsc;
  char_data *obj, *swap, *previous = NULL;

  extern void insert_mob_proto(char_data *mob);
  extern void render_simple_mob(char_data *ch);
  
  if (IS_SIMPLE_MOB(OLC_MOB(ch)))
    render_simple_mob(OLC_MOB(ch));

  if (OLC_DATA(ch)->func)
    SET_BIT(MOB_FLAGS(OLC_MOB(ch)), MOB_SPEC);
  else
    REMOVE_BIT(MOB_FLAGS(OLC_MOB(ch)), MOB_SPEC);

  /* write to internal tables */
  if (mob_index[OLC_NUM(ch)]) {
    /* now safe to free old proto and write over */
    FREE (mob_index[OLC_NUM(ch)]->proto);
    mob_index[OLC_NUM(ch)]->proto = OLC_MOB(ch);
  } else {
    insert_mob_proto(OLC_MOB(ch));
    // Changepoint:  We'll want to allow for editing of specprocs later.
  }

  // Save the special procedures
  mob_index[OLC_NUM(ch)]->func = OLC_DATA(ch)->func;
  if (mob_index[OLC_NUM(ch)]->farg) {
    FREE(mob_index[OLC_NUM(ch)]->farg);
  }
  mob_index[OLC_NUM(ch)]->farg = OLC_DATA(ch)->farg;
  OLC_DATA(ch)->farg = NULL;

  free_int_list(mob_index[OLC_NUM(ch)]->triggers);
  mob_index[OLC_NUM(ch)]->triggers = NULL;
  if (OLC_SCRIPT(ch) && TRIGGERS(OLC_SCRIPT(ch)))
    mob_index[OLC_NUM(ch)]->triggers = script_to_int_list(OLC_SCRIPT(ch));

  OLC_MOB(ch) = NULL;
  olc_add_to_save_list(zone_table[OLC_ZNUM(ch)].number, OLC_MEDIT);
}



/**************************************************************************
 Menu functions 
 **************************************************************************/

/*
 * Display positions. (sitting, standing, etc)
 */
void medit_disp_positions(char_data *ch)
{
  int i;

#if defined(CLEAR_SCREEN)
  send_to_char("[H[J", ch);
#endif
  for (i = 0; *position_types[i] != '\n'; i++) {
    sprintf(buf, "&cG%2d&c0) %s\r\n", i, position_types[i]);
    send_to_char(buf, ch);
  }
  send_to_char("Enter position number : ", ch);
}

/*-------------------------------------------------------------------*/

// Display the mob's skills - DH.

void medit_disp_skills(char_data *ch)
{
  struct skill_store *skill = NULL;

#if defined(CLEAR_SCREEN)
  send_to_char("[H[J", ch);
#endif

  CHAR_SKILL(OLC_MOB(ch)).GetTable(&skill);

  strcpy(buf, "\r\nSkills known:\r\n\r\n");
  
  if (skill == NULL) {
    strcat(buf, " - NONE!\r\n");
  } else {
    strcat(buf, "&cYSkill                     Points Chance\r\n");

    while (skill) {
      sprintf(buf + strlen(buf), "&cG%-25.25s    &cB%3d    %3d\r\n", spells[skill->skillnum],
  	      skill->proficient, SKILLCHANCE(OLC_MOB(ch), skill->skillnum, skill));
      skill = skill->next;
    }
  }

  strcat(buf, "\r\n&c0Enter a skill name to add or edit (0 quits) : ");
  
  send_to_char(buf, ch);
}

/*-------------------------------------------------------------------*/

/*
 * Display attack types menu.
 */
void medit_disp_attack_types(char_data *ch)
{
  int counter, columns = 0;

#if defined(CLEAR_SCREEN)
  send_to_char("[H[J", ch);
#endif
  for (counter = FIRST_COMBAT_MESSAGE; counter <= TYPE_GARROTE; ++counter) 
  { sprintf(buf, "&cG%2d&c0) %-20.20s ",
	    counter - FIRST_COMBAT_MESSAGE, spells[counter]);
    if(!(++columns % 2))
      strcat(buf, "\r\n");
    send_to_char(buf, ch);
  }
  send_to_char("Enter attack type : ", ch);
}

/*-------------------------------------------------------------------*/

/*
 * Display flags menu.
 */
void medit_disp_flags(char_data *ch)
{
  int i, columns = 0;

#if defined(CLEAR_SCREEN)
  send_to_char("[H[J", ch);
#endif
  oasis_gen_edit(ch, "", OLC_MENU(ch), "");
}

/*-------------------------------------------------------------------*/

/*
 * Display main menu.
 */
void medit_disp_menu(char_data *ch)
{
  struct char_data *mob;
  extern const char *class_types[];
  extern const char *race_types[];

  mob = OLC_MOB(ch);

  if (MOB_TYPE(mob) < 0)
    MOB_TYPE(mob) = 0;

  sprintbit(MOB_FLAGS(mob), action_bits, buf1);
  sprintbit(AFF_FLAGS(mob), affected_bits, buf2);

  sprintf(buf,
#if defined(CLEAR_SCREEN)
"[H[J"
#endif
	"-- Mob Number:  [&cC%d&c0]    %s%s\r\n"
 	"&cG1&c0) Alias: &cY%s\r\n"
 	"&cG2&c0) S-Desc: &cY%s\r\n"
 	"&cG3&c0) L-Desc:-\r\n&cY%s"
 	"&cG4&c0) D-Desc:-\r\n&cY%s"
        "&cG5&c0) Sex         : &cY%-15.15s"
	"&cGB&c0) Position    : &cY%-15.15s\r\n"
        "&cG6&c0) Race        : &cY%-15.15s"
	"&cGC&c0) Default     : &cY%-15.15s\r\n"
	"&cG7&c0) Class       : &cY%-15.15s"
	"&cGD&c0) Attack      : &cY%-15.15s\r\n"
	"&cG8&c0) Gold        : &cC%-15d"
	"&cGE&c0) Max Riders  : &cC%-15d\r\n"
	"&cG9&c0) Alignment   : &cC%-15d"
	"&cGF&c0) Disposition : &cC%-15d\r\n"
	"&cGA&c0) XP Bonus    : &cC%-15d"
	"&cGG&c0) Bodytype    : &cC%-15s\r\n",

	OLC_NUM(ch),
        (OLC_SAVE(ch) == OLC_SAVE_COPY) ? "&cW&bb[ Copy ]&c0" : "",
        (OLC_SAVE(ch) == OLC_SAVE_OVERWRITE) ? "&cW&br[ OVERWRITING ]&c0" : "",
	ss_data(GET_ALIAS(mob)),
	ss_data(GET_SDESC(mob)),
	ss_data(GET_LDESC(mob)),
	ss_data(GET_DDESC(mob)),
	genders[(int)GET_SEX(mob)],
	  position_types[(int)GET_POS(mob)],
	race_types[(int)GET_RACE(mob)],
	  position_types[(int)GET_DEFAULT_POS(mob)],
	class_types[(int)GET_CLASS(mob)],
	  spells[MIN(MAX(GET_ATTACKTYPE(mob) + TYPE_HIT, 0), TOP_SKILLO_DEFINE)],
	GET_GOLD(mob),
	GET_MAX_RIDERS(mob), 
	GET_ALIGNMENT(mob),
        GET_DISPOSITION(mob), 
        GET_EXP_MOD(mob),
	bodytypes[GET_BODYTYPE(mob)]);
  send_to_char(buf, ch);

  sprintf(buf,
	  "&cGH&c0) NPC Flags : &cC%s\r\n"
	  "&cGI&c0) AFF Flags : &cC%s\r\n"
	  "&cGP&c0) Special procedure : &cC%s\r\n"
          "&cGS&c0) Script attachments\r\n"
          "&cGT&c0) Mobile type : &cY%-15s&c0",
	  buf1,
	  buf2,
	  (OLC_DATA(ch)->func == NULL) ? "None" : spec_mob_name (OLC_DATA(ch)->func),
	  mobile_types[MOB_TYPE(mob)]);

  if (IS_SIMPLE_MOB(mob)) {
    sprintf(buf + strlen(buf), "&cGX&c0) Total Points : &cC%d\r\n", 
            GET_TOTALPTS(mob) + GET_EXP_MOD(mob));
  } else {
    GET_MAX_HIT(mob) = (GET_HIT(mob) * GET_MANA(mob) / 2 + 1) + GET_MOVE(mob);
    GET_MAX_MANA(mob) = GET_INT(mob) * 10;
    GET_MAX_MOVE(mob) = GET_STR(mob) * 10;

    GET_TOTALPTS(mob) = sum_char_pts(mob);
    sprintf(buf + strlen(buf), 
            "Total Points : %d\r\n"
	    "&cGX&c0) Extended stats\r\n", 
	    GET_TOTALPTS(mob));
  }

  strcat(buf, "&cGQ&c0) Quit\r\n"
	      "Enter choice : ");

  send_to_char(buf, ch);

  OLC_MENU(ch) = MEDIT_MAIN_MENU;
}


void medit_disp_extended_menu(char_data *ch)
{
  char_data *mob = OLC_MOB(ch);

  GET_MAX_HIT(mob) = (GET_HIT(mob) * GET_MANA(mob) / 2 + 1) + GET_MOVE(mob);
  GET_MAX_MANA(mob) = GET_INT(mob) * 10;
  GET_MAX_MOVE(mob) = GET_STR(mob) * 10;

  GET_TOTALPTS(mob) = sum_char_pts(mob);

  send_to_charf(ch,
	"&ccTotal Points : &cW%d&c0\r\n\n"
 	"&cG1&c0) Strength:      [&cC%5d&c0]  &cG7&c0) Hitroll:       [&cC%5d&c0]\r\n"
	"&cG2&c0) Intelligence:  [&cC%5d&c0]  &cG8&c0) Damroll:       [&cC%5d&c0]\r\n"
	"&cG3&c0) Wisdom:        [&cC%5d&c0]  &cG9&c0) Dam Resist:    [&cC%5d&c0]\r\n"
	"&cG4&c0) Dexterity:     [&cC%5d&c0]  &cGA&c0) Num HP Dice:   [&cC%5d&c0]\r\n"
	"&cG5&c0) Constitution:  [&cC%5d&c0]  &cGB&c0) Size HP Dice:  [&cC%5d&c0]\r\n"
	"&cG6&c0) Charisma:      [&cC%5d&c0]  &cGC&c0) HP Bonus:      [&cC%5d&c0]\r\n\n"
	"&cGL&c0) Level:         [&cC%5ld&c0]  &cGS&c0) Skills\r\n"
	  "&cGQ&c0) Quit\r\n"
	  "Enter choice : ",
	GET_TOTALPTS(mob),
	GET_STR(mob), GET_HITROLL(mob), 
	GET_INT(mob), GET_DAMROLL(mob), 
	GET_WIS(mob), GET_CHAR_DR(mob),
	GET_DEX(mob), GET_HIT(mob), 
	GET_CON(mob), GET_MANA(mob),
	GET_CHA(mob), GET_MOVE(mob),
	GET_LEVEL(mob));

  OLC_MENU(ch) = MEDIT_EXTENDED;
}


/************************************************************************
 *			The GARGANTAUN event handler			*
 ************************************************************************/

void medit_parse(char_data *ch, char *arg)
{
  int i;

  if (OLC_MENU(ch) > MEDIT_NUMERICAL_RESPONSE && OLC_MENU(ch) < SCRIPT_MAIN_MENU) {
    if (!*arg || (!isdigit(arg[0]) && ((*arg == '-') && (!isdigit(arg[1]))))) {
      send_to_char("Field must be numerical, try again : ", ch);
      return;
    }
  }
  switch (OLC_MENU(ch)) {
/*-------------------------------------------------------------------*/
  case MEDIT_CONFIRM_SAVESTRING:
    /*
     * Ensure mob has MOB_ISNPC set or things will go pair shaped.
     */
    SET_BIT(MOB_FLAGS(OLC_MOB(ch)), MOB_ISNPC);
    switch (*arg) {
    case 'y':
    case 'Y':
      /*
       * Save the mob in memory and to disk.
       */
      send_to_char("Saving mobile to memory.\r\n", ch);
      medit_save_internally(ch);
      sprintf(buf, "OLC: %s edits mob %d", GET_NAME(ch), OLC_NUM(ch));
      mudlog(buf, CMP, MAX(TRUST_CREATOR, GET_INVIS_LEV(ch)), TRUE);
      /* FALL THROUGH */
    case 'n':
    case 'N':
      cleanup_olc(ch, CLEANUP_ALL);
      return;
    default:
      send_to_char("Invalid choice!\r\n", ch);
      send_to_char("Do you wish to save the mobile? : ", ch);
      return;
    }
    break;

/*-------------------------------------------------------------------*/
  case MEDIT_MAIN_MENU:
    i = 0;
    switch (*arg) {
    case 'q':
    case 'Q':
      if (OLC_SAVE(ch)) {	/* Anything been changed? */
	send_to_char("Do you wish to save the changes to the mobile? (y/n) : ", ch);
	OLC_MENU(ch) = MEDIT_CONFIRM_SAVESTRING;
      } else
	cleanup_olc(ch, CLEANUP_ALL);
      return;
    case '1':
      OLC_MENU(ch) = MEDIT_ALIAS;
      i--;
      break;
    case '2':
      OLC_MENU(ch) = MEDIT_S_DESC;
      i--;
      break;
    case '3':
      OLC_MENU(ch) = MEDIT_L_DESC;
      i--;
      break;
    case '4':
#ifdef GOT_RID_OF_IT
      OLC_MENU(ch) = MEDIT_D_DESC;
      SEND_TO_Q("Enter mob description: (/s saves /h for help)\r\n\r\n", d);
      d->backstr = NULL;
      if (OLC_MOB(ch)->player.description) {
	send_to_char(OLC_MOB(ch)->player.description, ch);
	d->backstr = str_dup(OLC_MOB(ch)->player.description);
      }
      d->str = &OLC_MOB(ch)->player.description;
      d->max_str = MAX_MOB_DESC;
      d->mail_to = 0;
      OLC_SAVE(ch) = 1;
      return;
#else
      send_to_char("Enter mob description: (/s saves /h for help)\r\n\r\n", ch);
      oasis_gen_edit(ch, "", MEDIT_D_DESC, "");
      OLC_SAVE(ch) = OLC_SAVE_YES;
      return;
#endif
      break;
    case '5':
      OLC_MENU(ch) = MEDIT_SEX;
      oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      send_to_char("Enter choice : ", ch);
      return;
    case '6':
      OLC_MENU(ch) = MEDIT_RACE;
      oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      GET_BODYTYPE(OLC_MOB(ch)) = (race_bodytype[GET_RACE(OLC_MOB(ch))]);
      send_to_char("Enter choice : ", ch);
      return;
    case '7':
      OLC_MENU(ch) = MEDIT_CLASS;
      oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      send_to_char("Enter choice : ", ch);
      return;
    case '8':
      OLC_MENU(ch) = MEDIT_GOLD;
      i++;
      break;
    case '9':
      OLC_MENU(ch) = MEDIT_ALIGNMENT;
      i++;
      break;
    case 'a':
    case 'A':
      OLC_MENU(ch) = MEDIT_EXP;
      i++;
      break;
    case 'b':
    case 'B':
      OLC_MENU(ch) = MEDIT_POS;
      medit_disp_positions(ch);
      return;
    case 'c':
    case 'C':
      OLC_MENU(ch) = MEDIT_DEFAULT_POS;
      medit_disp_positions(ch);
      return;
    case 'd':
    case 'D':
      OLC_MENU(ch) = MEDIT_ATTACK;
      oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      // medit_disp_attack_types(ch);
      return;
    case 'e':
    case 'E':
      OLC_MENU(ch) = MEDIT_MAX_RIDERS;
      i++;
      break;
    case 'f':
    case 'F':
      OLC_MENU(ch) = MEDIT_DISPOSITION;
      i++;
      break;
    case 'g':
    case 'G':
      OLC_MENU(ch) = MEDIT_BODYTYPE;
      oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      return;
    case 'h':
    case 'H':
      OLC_MENU(ch) = MEDIT_NPC_FLAGS;
      oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      return;
    case 'i':
    case 'I':
      OLC_MENU(ch) = MEDIT_AFF_FLAGS;
      oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      return;
    case 'p':
    case 'P':
      olc_disp_specproc_menu(ch);
      OLC_MENU(ch) = MEDIT_SPECPROC_MENU;
      return;
    case 's':
    case 'S':
      dg_script_menu(ch);
      return;
    case 't':
    case 'T':
      OLC_MENU(ch) = MEDIT_MOBTYPE;
      oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      return;
    case 'x':
    case 'X':
      if (IS_SIMPLE_MOB(OLC_MOB(ch))) {
        OLC_MENU(ch) = MEDIT_TOTALPTS;
        oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      } else {
        medit_disp_extended_menu(ch);
      }
      return;
    default:
      medit_disp_menu(ch);
      return;
    }
    if (i != 0) {
      send_to_char(i == 1 ? "\r\nEnter new value : " :
		   i == -1 ? "\r\nEnter new text :\r\n] " :
			"\r\nOops...:\r\n", ch);
      return;
    }
    break;

/*-------------------------------------------------------------------*/
  case SCRIPT_MAIN_MENU:
  case SCRIPT_NEW_TRIGGER:
  case SCRIPT_DEL_TRIGGER:
#ifdef GOT_RID_OF_IT
    if (dg_script_edit_parse(ch, arg)) return;
#else
    dg_script_edit_parse(ch, arg);
    return;
#endif
    break;
/*-------------------------------------------------------------------*/
  case MEDIT_ALIAS:
    if (GET_ALIAS(OLC_MOB(ch)))
      ss_free(GET_ALIAS(OLC_MOB(ch)));
    GET_ALIAS(OLC_MOB(ch)) = (arg && *arg) ? ss_create(arg) : ss_create("undefined");
    break;
/*-------------------------------------------------------------------*/
  case MEDIT_S_DESC:
    if (GET_SDESC(OLC_MOB(ch)))
      ss_free(GET_SDESC(OLC_MOB(ch)));
    GET_SDESC(OLC_MOB(ch)) = (arg && *arg) ? ss_create(arg) : ss_create("undefined");
    break;
/*-------------------------------------------------------------------*/
  case MEDIT_L_DESC:
    if (GET_LDESC(OLC_MOB(ch)))
      ss_free(GET_LDESC(OLC_MOB(ch)));
    if (arg && *arg) {
      strcpy(buf, arg);
      strcat(buf, "\r\n");
      GET_LDESC(OLC_MOB(ch)) = ss_create(buf);
    } else
      GET_LDESC(OLC_MOB(ch)) = ss_create("undefined");

    break;
/*-------------------------------------------------------------------*/
  case MEDIT_D_DESC:
    /*
     * We should never get here.
     */
    cleanup_olc(ch, CLEANUP_ALL);
    mudlog("SYSERR: OLC: medit_parse(): Reached D_DESC case!",
			BRF, TRUST_CREATOR, TRUE);
    send_to_char("Oops...\r\n", ch);
    break;

#ifdef GOT_RID_OF_IT
/*-------------------------------------------------------------------*/
  case MEDIT_NPC_FLAGS:
    switch (*arg && oasis_gen_edit(ch, "", MEDIT_NPC_FLAGS, arg)) {
      case 0: medit_disp_menu(ch); return;
      default: 
        if (!OLC_SAVE(ch))
	  OLC_SAVE(ch) = OLC_SAVE_YES;
    medit_disp_flags(ch);
    return;
    }
/*-------------------------------------------------------------------*/
#endif
  case MEDIT_AFF_FLAGS:
  case MEDIT_NPC_FLAGS:
    switch (*arg && oasis_gen_edit(ch, "", OLC_MENU(ch), arg)) {
    case 0: 
      medit_disp_menu(ch); 
      return;
      default: 
        if (!OLC_SAVE(ch))
	  OLC_SAVE(ch) = OLC_SAVE_YES;
      medit_disp_flags(ch);
    return;
    }
/*-------------------------------------------------------------------*/

/*
 * Numerical responses.
 */

  case MEDIT_SEX:
    oasis_gen_edit(ch, "", OLC_MENU(ch), arg);
    break;

  case MEDIT_SKILLS:
    if ((!*arg) || (*arg == '0')) {
      OLC_MENU(ch) = MEDIT_MAIN_MENU;
      medit_disp_extended_menu(ch);
      return;
    }
    OLC_VAL(ch) = find_skill_num(arg);
    if (!LEARNABLE_SKILL(OLC_VAL(ch))) {
      send_to_char("That is not a learnable skill.  Try again.\r\n", ch);
      return;
    }
    OLC_MENU(ch) = MEDIT_SKILLPTS;
    send_to_char("Enter the points invested : ", ch);
    return;

  case MEDIT_SKILLPTS:
    SET_SKILL(OLC_MOB(ch), OLC_VAL(ch), MAX(atoi(arg), 0));
    OLC_MENU(ch) = MEDIT_SKILLS;
    OLC_VAL(ch) = 0;
    medit_disp_skills(ch);
    return;

  case MEDIT_TOTALPTS:
    GET_TOTALPTS(OLC_MOB(ch)) = atoi(arg) - GET_EXP_MOD(OLC_MOB(ch));
    if (!OLC_SAVE(ch))
      OLC_SAVE(ch) = OLC_SAVE_YES;
    medit_disp_menu(ch);
    return;

  case MEDIT_EXP:
  case MEDIT_GOLD:
  case MEDIT_POS:
  case MEDIT_DEFAULT_POS:
  case MEDIT_ATTACK:
  case MEDIT_ALIGNMENT:
  case MEDIT_RACE:
  case MEDIT_CLASS:
  case MEDIT_MAX_RIDERS:
  case MEDIT_MOBTYPE:
  case MEDIT_BODYTYPE:
  case MEDIT_DISPOSITION:
    switch (*arg && oasis_gen_edit(ch, "", OLC_MENU(ch), arg)) {
    case 0: break;
    default: 
      if (!OLC_SAVE(ch))
	OLC_SAVE(ch) = OLC_SAVE_YES;
    }
    medit_disp_menu(ch); 
    return;

  case MEDIT_HITROLL:
  case MEDIT_DAMROLL:
  case MEDIT_AC:
  case MEDIT_LEVEL:
    switch (*arg && oasis_gen_edit(ch, "", OLC_MENU(ch), arg)) {
    case 0: break;
    default: 
      if (!OLC_SAVE(ch))
	OLC_SAVE(ch) = OLC_SAVE_YES;
    }
    medit_disp_extended_menu(ch);
    return;

  case MEDIT_STR:
  case MEDIT_INT:
  case MEDIT_WIS:
  case MEDIT_DEX:
  case MEDIT_CON:
  case MEDIT_CHA:
    switch (*arg && oasis_gen_edit(ch, "", OLC_MENU(ch), arg)) {
    case 0: break;
    default: 
      if (!OLC_SAVE(ch))
	OLC_SAVE(ch) = OLC_SAVE_YES;
    }
    OLC_MOB(ch)->real_abils = OLC_MOB(ch)->aff_abils;
    medit_disp_extended_menu(ch);
    return;

  case MEDIT_NUM_HP_DICE:
  case MEDIT_SIZE_HP_DICE:
  case MEDIT_ADD_HP:
    switch (*arg && oasis_gen_edit(ch, "", OLC_MENU(ch), arg)) {
    case 0: break;
    default: 
      if (!OLC_SAVE(ch))
	OLC_SAVE(ch) = OLC_SAVE_YES;
    }
    GET_MAX_HIT(OLC_MOB(ch)) = (GET_HIT(OLC_MOB(ch)) * 
                                GET_MANA(OLC_MOB(ch)) / 2 + 1) + 
				GET_MOVE(OLC_MOB(ch));
    medit_disp_extended_menu(ch);
    return;

  case MEDIT_SPECPROC_MENU:
    if (*arg) {
      olc_edit_special(ch, arg);
      medit_disp_menu(ch);
      OLC_SAVE(ch) = OLC_SAVE_YES;
    } else {
      medit_disp_menu(ch);
    }
    return;

  case MEDIT_EXTENDED:
    switch(*arg) {
  // Extended menu
    case '1':
      OLC_MENU(ch) = MEDIT_STR;
    break;
    case '2':
      OLC_MENU(ch) = MEDIT_INT;
      i++;
    break;
    case '3':
      OLC_MENU(ch) = MEDIT_WIS;
      i++;
    break;
    case '4':
      OLC_MENU(ch) = MEDIT_DEX;
      i++;
    break;
    case '5':
      OLC_MENU(ch) = MEDIT_CON;
      i++;
    break;
    case '6':
      OLC_MENU(ch) = MEDIT_CHA;
      i++;
    break;
    case '7':
      OLC_MENU(ch) = MEDIT_HITROLL;
      i++;
    break;
    case '8':
      OLC_MENU(ch) = MEDIT_DAMROLL;
      i++;
    break;
    case '9':
      OLC_MENU(ch) = MEDIT_AC;
      i++;
    break;
    case 'a':
    case 'A':
      OLC_MENU(ch) = MEDIT_NUM_HP_DICE;
      i++;
    break;
    case 'b':
    case 'B':
      OLC_MENU(ch) = MEDIT_SIZE_HP_DICE;
      i++;
    break;
    case 'c':
    case 'C':
      OLC_MENU(ch) = MEDIT_ADD_HP;
      i++;
    break;
    case 'l':
    case 'L':
      OLC_MENU(ch) = MEDIT_LEVEL;
      i++;
    break;
    case 'p':
    case 'P':
      olc_disp_specproc_menu(ch);
      OLC_MENU(ch) = MEDIT_SPECPROC_MENU;
      return;
    case 's':
    case 'S':
      OLC_MENU(ch) = MEDIT_SKILLS;
      medit_disp_skills(ch);
      return;
    case 'q':
    case 'Q':
      medit_disp_menu(ch);
      return;
    default: 
      medit_disp_extended_menu(ch);
      return;
    }
    return;


/*-------------------------------------------------------------------*/
  default:
    /*
     * We should never get here.
     */
    cleanup_olc(ch, CLEANUP_ALL);
    mudlog("SYSERR: OLC: medit_parse(): Reached default case!", BRF, TRUST_CREATOR, TRUE);
    send_to_char("Oops...\r\n", ch);
    break;
  }
/*-------------------------------------------------------------------*/

/*
 * END OF CASE 
 * If we get here, we have probably changed something, and now want to
 * return to main menu.  Use OLC_SAVE as a 'has changed' flag  
 */

  OLC_SAVE(ch) = OLC_SAVE_YES;
  medit_disp_menu(ch);
}
/*
 * End of medit_parse(), thank god.
 */
