/***************************************************************************
 *  Original Diku Mud copyright (C) 1990, 1991 by Sebastian Hammer,        *
 *  Michael Seifert, Hans Henrik St{rfeldt, Tom Madsen, and Katja Nyboe.   *
 *                                                                         *
 *  Merc Diku Mud improvments copyright (C) 1992, 1993 by Michael          *
 *  Chastain, Michael Quan, and Mitchell Tse.                              *
 *                                                                         *
 *  In order to use any part of this Merc Diku Mud, you must comply with   *
 *  both the original Diku license in 'license.doc' as well the Merc       *
 *  license in 'license.txt'.  In particular, you may not remove either of *
 *  these copyright notices.                                               *
 *                                                                         *
 *  Much time and thought has gone into this software and you are          *
 *  benefitting.  We hope that you share your changes too.  What goes      *
 *  around, comes around.                                                  *
 ***************************************************************************/

/***************************************************************************
 *  The MOBprograms have been contributed by N'Atas-ha.  Any support for   *
 *  these routines should not be expected from Merc Industries.  However,  *
 *  under no circumstances should the blame for bugs, etc be placed on     *
 *  Merc Industries.  They are not guaranteed to work on all systems due   *
 *  to their frequent use of strxxx functions.  They are also not the most *
 *  efficient way to perform their tasks, but hopefully should be in the   *
 *  easiest possible way to install and begin using. Documentation for     *
 *  such installation can be found in INSTALL.  Enjoy........    N'Atas-Ha *
 ***************************************************************************/

#include "conf.h"
#include "sysdep.h"


#include "structs.h"
#include "scripts.h"
#include "index.h"
#include "db.h"
#include "utils.h"
#include "handler.h"
#include "find.h"
#include "interpreter.h"
#include "comm.h"
#include "spells.h"
#include "events.h"
#include "sblock.h"

extern struct descriptor_data *descriptor_list;
extern sh_int find_target_room(char_data * ch, char *rawroomstr);


/*
 * Local functions.
 */

/* attaches mob's name and vnum to msg and sends it to script_log */
void mob_log(char_data * mob, char *msg)
{
    char buf[MAX_INPUT_LENGTH + 100];

    void script_log(char *msg);

    sprintf(buf, "Mob (%s, VNum %d): %s",
	    GET_SHORT(mob), GET_MOB_NUM(mob), msg);
    script_log(buf);
}


/* string prefix routine */
bool str_prefix(const char *astr, const char *bstr)
{
    if (!astr) {
	log("Strn_cmp: null astr.");
	return TRUE;
    }
    if (!bstr) {
	log("Strn_cmp: null astr.");
	return TRUE;
    }
  for (; *astr; astr++, bstr++) {
    if (LOWER(*astr) != LOWER(*bstr))
      return TRUE;
    }
    return FALSE;
}
/*
   ** macro to determine if a mob is permitted to use these commands
 */
#define MOB_OR_IMPL(ch) \
  (IS_NPC(ch) && (!(ch)->desc || GET_TRUST((ch)->desc->original)>=TRUST_IMPL))



/* mob commands */

/* prints the argument to all the rooms aroud the mobile */
ACMD(do_masound)
{
    if (!MOB_OR_IMPL(ch)) {
	send_to_char("Huh?!?\r\n", ch);
	return;
    }
    if (AFF_FLAGGED(ch, AFF_CHARM))
	return;

    do_scriptasound((game_data *) ch, argument, cmd, subcmd, IN_ROOM(ch));
}


/* lets the mobile kill any player or mobile without murder */
ACMD(do_mkill)
{
    char arg[MAX_INPUT_LENGTH];
    char_data *victim;
  
    if (!MOB_OR_IMPL(ch)) {
	send_to_char("Huh?!?\r\n", ch);
	return;
    }

    if (AFF_FLAGGED(ch, AFF_CHARM))
	return;
  
    one_argument(argument, arg);
    
    if (!*arg) {
	mob_log(ch, "mkill called with no argument");
	return;
    }
    if (*arg == UID_CHAR) {
      if (!(victim = get_char(arg))) {
      sprintf(buf, "mkill: victim (%s) not found", arg);
      mob_log(ch, buf);
      return;
      }
    } else if (!(victim = get_char_room_vis(ch, arg))) {
    sprintf(buf, "mkill: victim (%s) not found", arg);
      mob_log(ch, buf);
	return;
    }
    if (victim == ch) {
	mob_log(ch, "mkill: victim is self");
	return;
    }
  if (AFF_FLAGGED(ch, AFF_CHARM) && ch->master == victim) {
	mob_log(ch, "mkill: charmed mob attacking master");
	return;
    }
    if (FIGHTING(ch)) {
	mob_log(ch, "mkill: already fighting");
	return;
    }
    hit(ch, victim);
    return;
}


/*
 * lets the mobile destroy an object in its inventory
 * it can also destroy a worn object and it can destroy 
 * items using all.xxxxx or just plain all of them
 */
ACMD(do_mjunk)
{
    char arg[MAX_INPUT_LENGTH];
    int pos, dotmode;
    obj_data *obj;
    obj_data *obj_next;
  
    if (!MOB_OR_IMPL(ch)) {
	send_to_char("Huh?!?\r\n", ch);
	return;
    }
    if (AFF_FLAGGED(ch, AFF_CHARM))
	return;

    one_argument(argument, arg);
  
    if (!*arg) {
      mob_log(ch, "mjunk called with no argument");
      return;
    } else {
      dotmode = find_all_dots(arg);

      if (dotmode == FIND_ALL) {
  	if (ch->carrying) {
  	  for (obj = ch->carrying; obj; obj = obj_next) {
  	    obj_next = obj->next_content;
  	    extract_obj(obj);
  	  }
  	}
      } else if (dotmode == FIND_ALLDOT) {
  	if (!*arg) {
  	  mob_log(ch, "mjunk called with no argument after all.");
  	  return;
  	}
  	// Should we have mjunk working this way or not?  I dunno
  	//	while ((obj = get_object_in_equip_vis(ch, arg, ch->equipment, &pos))) {
  	//	  unequip_char(ch, pos);
  	//	  extract_obj(obj);
  	//	}
  	if ((obj = get_obj_in_list_vis(ch, arg, ch->carrying))) {
  	  while (obj) {
  	    obj_next = get_obj_in_list_vis(ch, arg, obj->next_content);
  	    extract_obj(obj);
  	    obj = obj_next;
  	  }
  	}
      } else {
  	if ((obj = get_obj_in_list_vis(ch, arg, ch->carrying)))
  	  extract_obj(obj);
      }
    }

#ifdef GOT_RID_OF_IT
    if (find_all_dots(arg) != FIND_INDIV) {
    if ((obj = get_object_in_equip_vis(ch, arg, ch->equipment, &pos)) != NULL) {
	    unequip_char(ch, pos);
	    extract_obj(obj);
	    return;
	}
    if ((obj = get_obj_in_list_vis(ch, arg, ch->carrying)) != NULL)
	    extract_obj(obj);
	return;
    } else {
	for (obj = ch->carrying; obj != NULL; obj = obj_next) {
	    obj_next = obj->next_content;
#ifdef GOT_RID_OF_IT
	// I don't know WHAT they were thinking here. -DH
      if (arg[3] == '\0' || isname(arg + 4, ss_data(obj->name))) {
		extract_obj(obj);
	    }
#endif
	    if (isname(arg, ss_data(obj->name))) {
		extract_obj(obj);
	    }
	}
    while ((obj = get_object_in_equip_vis(ch, arg, ch->equipment, &pos))) {
	    unequip_char(ch, pos);
	    extract_obj(obj);
	}   
    }
    return;
#endif
}


/* prints the message to everyone in the room other than the mob and victim */
ACMD(do_mechoaround)
{
    if (!MOB_OR_IMPL(ch)) {
    send_to_char("Huh?!?\r\n", ch);
	return;
    }
    if (AFF_FLAGGED(ch, AFF_CHARM))
	return;

    do_scriptsend((game_data *) ch, argument, cmd, SCMD_ECHOAROUND, IN_ROOM(ch));
}


/* sends the message to only the victim */
ACMD(do_msend)
{
    if (!MOB_OR_IMPL(ch)) {
    send_to_char("Huh?!?\r\n", ch);
	return;
    }
    if (AFF_FLAGGED(ch, AFF_CHARM))
	return;
  
    do_scriptsend((game_data *) ch, argument, cmd, subcmd, IN_ROOM(ch));
}


/* prints the message to the room at large */
ACMD(do_mecho)
{
    if (!MOB_OR_IMPL(ch)) {
        send_to_char("Huh?!?\r\n", ch);
	return;
    }
    if (AFF_FLAGGED(ch, AFF_CHARM))
	return;
  
    do_scriptecho((game_data *) ch, argument, cmd, subcmd, IN_ROOM(ch));
}


/*
 * lets the mobile load an item or mobile.  All items
 * are loaded into inventory, unless it is NO-TAKE. 
 */
ACMD(do_mload)
{
    char arg1[MAX_INPUT_LENGTH], arg2[MAX_INPUT_LENGTH];
  
    if (!MOB_OR_IMPL(ch)) {
	send_to_char("Huh?!?\r\n", ch);
	return;
    }
    if (AFF_FLAGGED(ch, AFF_CHARM))
	return;

    do_scriptload((game_data *) ch, argument, cmd, subcmd, IN_ROOM(ch));
}


/*
 * lets the mobile purge all objects and other npcs in the room,
 * or purge a specified object or mob in the room.  It can purge
 *  itself, but this will be the last command it does.
 */
ACMD(do_mpurge)
{
    if (!MOB_OR_IMPL(ch)) {
	send_to_char("Huh?!?\r\n", ch);
	return;
    }
    if (AFF_FLAGGED(ch, AFF_CHARM))
	return;

    if (ch->desc && (GET_TRUST(ch->desc->original) < TRUST_IMPL))
	return;

    do_scriptpurge((game_data *) ch, argument, cmd, subcmd, IN_ROOM(ch));
}


/* lets the mobile goto any location it wishes that is not private */
ACMD(do_mgoto)
{
    char arg[MAX_INPUT_LENGTH];
    sh_int location;
  
    if (!MOB_OR_IMPL(ch)) {
	send_to_char("Huh?!?\r\n", ch);
	return;
    }

    if (AFF_FLAGGED(ch, AFF_CHARM))
	return;
  
    one_argument(argument, arg);

    if (!*arg) {
	mob_log(ch, "mgoto called with no argument");
	return;
    }
    if ((location = find_target_room(ch, arg)) == NOWHERE) {
	mob_log(ch, "mgoto: invalid location");
	return;
    }
    if (FIGHTING(ch))
	stop_fighting(ch);
    
    char_from_room(ch);
    char_to_room(ch, location);
}


/* lets the mobile do a command at another location. Very useful */
ACMD(do_mat)
{
    if (!MOB_OR_IMPL(ch)) {
	send_to_char("Huh?!?\r\n", ch);
	return;
    }
    if (AFF_FLAGGED(ch, AFF_CHARM))
	return;

    do_scriptat((game_data *) ch, argument, cmd, subcmd, IN_ROOM(ch));
}


/*
 * lets the mobile transfer people.  the all argument transfers
 * everyone in the current room to the specified location
 */
ACMD(do_mteleport)
{
    if (!MOB_OR_IMPL(ch)) {
	send_to_char("Huh?!?\r\n", ch);
	return;
    }

    if (AFF_FLAGGED(ch, AFF_CHARM))
	return;

    do_scriptteleport((game_data *) ch, argument, cmd, subcmd, IN_ROOM(ch));
}


/*
 * lets the mobile transfer people.  the all argument transfers
 * everyone in the current room to the specified location
 */
ACMD(do_mtransfer)
{
  if (!MOB_OR_IMPL(ch)) {
      send_to_char("Huh?!?\r\n", ch);
      return;
  }
  if (AFF_FLAGGED(ch, AFF_CHARM))
      return;

  do_scriptteleport((game_data *) ch, argument, cmd, subcmd, IN_ROOM(ch));
}


/*
 * lets the mobile force someone to do something.  must be mortal level
 * and the all argument only affects those in the room with the mobile
 */
ACMD(do_mforce)
{
    if (!MOB_OR_IMPL(ch)) {
	send_to_char("Huh?!?\r\n", ch);
	return;
    }
    if (AFF_FLAGGED(ch, AFF_CHARM))
	return;
  
    if (ch->desc && (GET_TRUST(ch->desc->original) < TRUST_IMPL))
	return;
  
    do_scriptforce((game_data *) ch, argument, cmd, subcmd, IN_ROOM(ch));
}


/* increases the target's exp */
ACMD(do_mexp)
{
    if (!MOB_OR_IMPL(ch)) {
	send_to_char("Huh?!?\r\n", ch);
	return;
    }
    if (AFF_FLAGGED(ch, AFF_CHARM))
	return;
  
    if (ch->desc && (GET_TRUST(ch->desc->original) < TRUST_IMPL))
	return;  

    do_scriptexp((game_data *) ch, argument, cmd, subcmd, IN_ROOM(ch));
}


// Hunt someone.  This is my implementation made previous to the dgbpl5
// release.
ACMD(do_mhunt)
{
  char arg[MAX_INPUT_LENGTH];
    struct char_data *victim;

    if (!MOB_OR_IMPL(ch)) {
      send_to_char("Huh?!?\r\n", ch);
      return;
    }
    if (AFF_FLAGGED(ch, AFF_CHARM))
      return;
  
    if (ch->desc && (GET_TRUST(ch->desc->original) < TRUST_IMPL))
      return;

    one_argument(argument, arg);

  if (arg[0] == '\0') {
	sprintf(buf3, "Mhunt - No argument: vnum %d.", ch->nr);
	mob_log(ch, buf3);
	return;
    }

//    if (FIGHTING(ch)) return;  // I want this to take anyway!

    if (*arg == UID_CHAR) {
      if (!(victim = get_char(arg))) {
	sprintf(buf, "mhunt: victim (%s) does not exist", arg);
      mob_log(ch, buf);
      return;
      }
    } else if (!(victim = get_char_vis(ch, arg))) {
	sprintf(buf, "mhunt: victim (%s) does not exist", arg);
      mob_log(ch, buf);
	return;
    }

    SET_BIT(MOB_FLAGS(ch), MOB_SEEKER); // Allows the mob to pass !MOB rooms

    HUNTING(ch) = GET_ID(victim);

}

ACMD(do_mseek)
{
  char arg[MAX_INPUT_LENGTH];
    struct char_data *victim;

    one_argument(argument, arg);
    if (arg[0] == '\0') {
	sprintf(buf3, "Mseek - No argument: vnum %d.", ch->nr);
	mob_log(ch, buf3);
	return;
    }

    if (!(victim = get_char_vis(ch, arg))) {
	sprintf(buf3, "Mseek - No such target: vnum %d.", ch->nr);
	mob_log(ch, buf3);
	return;
    }

    SET_BIT(MOB_FLAGS(ch), MOB_SEEKER); // Allows the mob to pass !MOB rooms

    SEEKING(ch) = GET_ID(victim);
}


ACMD(do_mroomseek)
{
  char arg[MAX_INPUT_LENGTH];
    sh_int room;

    one_argument(argument, arg);
    if (arg[0] == '\0') {
	sprintf(buf3, "Mroomseek - No argument: vnum %d.", ch->nr);
	mob_log(ch, buf3);
	return;
    }

    if ((room = find_target_room(ch, arg)) < 0) {
	sprintf(buf3, "Mroomseek - No such target: vnum %d.", ch->nr);
	mob_log(ch, buf3);
	return;
    }

    SET_BIT(MOB_FLAGS(ch), MOB_SEEKER); // Allows the mob to pass !MOB rooms

    if (real_room(room) != NOWHERE)
      ROOMSEEKING(ch) = room;

    return;
}


ACMD(do_minroomseek)
{
  char arg[MAX_INPUT_LENGTH];
    struct char_data *victim;

    one_argument(argument, arg);
    if (arg[0] == '\0') {
	sprintf(buf3, "Minroomseek - No argument: vnum %d.", ch->nr);
	mob_log(ch, buf3);
	return;
    }

    if (!(victim = get_char_vis(ch, arg))) {
	sprintf(buf3, "Minroomseek - No such target: vnum %d.", ch->nr);
	mob_log(ch, buf3);
	return;
    }

    SET_BIT(MOB_FLAGS(ch), MOB_SEEKER); // Allows the mob to pass !MOB rooms

    if (real_room(IN_ROOM(victim)) != NOWHERE)
      ROOMSEEKING(ch) = victim->in_room;
    return;
}


ACMD(do_mdelayed)
{
  char arg1[20];
  unsigned long delay;
  sh_int eventtype = 0;
  struct delayed_event_command *otd;
  extern EVENTFUNC(delayed_command);

  *arg1 = '\0';

  half_chop(argument, arg1, buf);
  delay = atoi(arg1);
  *arg1 = '\0';

  if (!delay) {
    sprintf(buf3, "Mdelayed - the delay is invalid. - vnum #%d", ch->nr);
    mob_log(ch, buf3);
    return;
  } else {
    delay *= PASSES_PER_SEC / 5;
  }

  /* Determine the eventtype */
  if (isdigit(buf[0])) {
    half_chop(buf, arg1, buf);
    eventtype = atoi(arg1);
  }
//  sprintf(buf1, "Ok. Executing '%s' in %ld seconds.\r\n", buf, delay / 5);
  //  send_to_char(buf1,ch);
  CREATE(otd, struct delayed_event_command, 1);

  otd->id = ch->id;
  otd->command = str_dup(buf);
  
  create_event(delayed_command, otd, delay, 0);
}


/* place someone into the mob's memory list */
ACMD(do_mremember)
{
    char_data *victim;
    struct script_memory *mem;
    char arg[MAX_INPUT_LENGTH];

    if (!MOB_OR_IMPL(ch)) {
      send_to_char("Huh?!?\r\n", ch);
      return;
    }
    if (AFF_FLAGGED(ch, AFF_CHARM))
      return;
  
    if (ch->desc && (GET_TRUST(ch->desc->original) < TRUST_IMPL))
      return;
  
    argument = one_argument(argument, arg);
  
    if (!*arg) {
      mob_log(ch, "mremember: bad syntax");
      return;
    }

    if (*arg == UID_CHAR) {
      if (!(victim = get_char(arg))) {
	sprintf(buf, "mremember: victim (%s) does not exist", arg);
      mob_log(ch, buf);
      return;
      }
    } else if (!(victim = get_char_vis(ch, arg))) {
	sprintf(buf, "mremember: victim (%s) does not exist", arg);
      mob_log(ch, buf);
      return;
    }
    /* create a structure and add it to the list */
    CREATE(mem, struct script_memory, 1);
  if (!SCRIPT_MEM(ch))
    SCRIPT_MEM(ch) = mem;
    else {
      struct script_memory *tmpmem = SCRIPT_MEM(ch);

    while (tmpmem->next)
      tmpmem = tmpmem->next;
      tmpmem->next = mem;
    }

    /* fill in the structure */
    mem->id = GET_ID(victim);
    if (argument && *argument) {
      mem->cmd = str_dup(argument);
    }
}


/* remove someone from the list */
ACMD(do_mforget)
{
    char_data *victim;
    struct script_memory *mem, *prev;
    char arg[MAX_INPUT_LENGTH];

    if (!MOB_OR_IMPL(ch)) {
      send_to_char("Huh?!?\r\n", ch);
      return;
    }
    if (AFF_FLAGGED(ch, AFF_CHARM))
      return;
  
    if (ch->desc && (GET_TRUST(ch->desc->original) < TRUST_IMPL))
      return;
  
    one_argument(argument, arg);
  
    if (!*arg) {
      mob_log(ch, "mforget: bad syntax");
      return;
    }

    if (*arg == UID_CHAR) {
      if (!(victim = get_char(arg))) {
	sprintf(buf, "mforget: victim (%s) does not exist", arg);
      mob_log(ch, buf);
      return;
      }
    } else if (!(victim = get_char_vis(ch, arg))) {
	sprintf(buf, "mforget: victim (%s) does not exist", arg);
      mob_log(ch, buf);
      return;
    }

    mem = SCRIPT_MEM(ch);
    prev = NULL;
    while (mem) {
      if (mem->id == GET_ID(victim)) {
      if (mem->cmd)
	free(mem->cmd);
      if (prev == NULL) {
	  SCRIPT_MEM(ch) = mem->next;
	  free(mem);
	  mem = SCRIPT_MEM(ch);
	} else {
	  prev->next = mem->next;
	  free(mem);
	  mem = prev->next;
	}
      } else {
	prev = mem;
	mem = mem->next;
      }
   }
}


/* transform into a different mobile */
ACMD(do_mtransform)
{
  if (!MOB_OR_IMPL(ch)) {
    send_to_char("Huh?!?\r\n", ch);
    return;
  }
  if (AFF_FLAGGED(ch, AFF_CHARM))
    return;
  
  do_scripttransform((game_data *) ch, argument, cmd, subcmd, IN_ROOM(ch));

#ifdef GOT_RID_OF_IT
// CHANGEPOINT - This needs work
  char arg[MAX_INPUT_LENGTH];
  char_data *newmob;
  obj_data *obj[NUM_WEARS];
  struct skill_store *skill = NULL;
  int pos;

  if (ch->desc) {
    send_to_char("You've got no VNUM to return to, you silly arse!  Try 'switch'.\r\n", ch);
    return;
  }
  one_argument(argument, arg);

  if (!*arg)
    mob_log(ch, "mtransform: missing argument");
  else if (!isdigit(*arg)) 
    mob_log(ch, "mtransform: bad argument");
  else {
    newmob = read_mobile(atoi(arg));
    if (newmob == NULL) {
      mob_log(ch, "mtransform: bad mobile vnum");
      return;
    }

    /* move new obj info over to old object and delete new obj */

    for (pos = 0; pos < NUM_WEARS; pos++) {
      if (GET_EQ(ch, pos))
	obj[pos] = unequip_char(ch, pos);
      else
	obj[pos] = NULL;
    }

    /* put the mob in the same room as ch so extract will work */
    char_to_room(newmob, IN_ROOM(ch));
    GET_WAS_IN(newmob) = GET_WAS_IN(ch);
    GET_WAS_IN(newmob) = GET_WAS_IN(ch);
    GET_HIT(newmob) = GET_HIT(ch);
    GET_MAX_HIT(newmob) = GET_MAX_HIT(ch);
    GET_EXP(newmob) = GET_EXP(ch);
    GET_GOLD(newmob) = GET_GOLD(ch);
    GET_POS(newmob) = GET_POS(ch);
    IS_CARRYING_W(newmob) = IS_CARRYING_W(ch);
    IS_CARRYING_N(newmob) = IS_CARRYING_N(ch);
    FIGHTING(newmob) = FIGHTING(ch);
    HUNTING(newmob) = HUNTING(ch);
    SEEKING(newmob) = SEEKING(ch);
    ROOMSEEKING(newmob) = ROOMSEEKING(ch);

    newmob->id = ch->id;
    newmob->affects = ch->affects;
    newmob->carrying = ch->carrying;
    // newmob->proto_script = ch->proto_script;
    newmob->script = ch->script;
    newmob->memory = ch->memory;
    newmob->next_in_room = ch->next_in_room;
    newmob->next = ch->next;
    newmob->next_fighting = ch->next_fighting;
    newmob->followers = ch->followers;
    newmob->master = ch->master;
    newmob->concentration = ch->concentration;

    // Copy over the skills
    CHAR_SKILL(ch).GetTable(&skill);

    while (skill) {
      SET_SKILL(newmob, skill->skillnum, skill->proficient);
      skill = skill->next;
    }

    ch->carrying = NULL;
    // ch->proto_script = NULL;
    ch->script = NULL;
    ch->memory = NULL;
    ch->next_in_room = NULL;
    ch->next = NULL;
    ch->next_fighting = NULL;
    ch->followers = NULL;
    ch->master = NULL;
    ch->affects = NULL;
    ch->concentration = NULL;

    GET_POINTS_EVENT(newmob, 0) = GET_POINTS_EVENT(ch, 0);
    GET_POINTS_EVENT(newmob, 1) = GET_POINTS_EVENT(ch, 1);
    GET_POINTS_EVENT(newmob, 2) = GET_POINTS_EVENT(ch, 2);
    GET_POINTS_EVENT(newmob, 3) = GET_POINTS_EVENT(ch, 3);
    GET_ACTION(newmob) = GET_ACTION(ch);
    GET_DAMAGE_EVENTS(newmob) = GET_DAMAGE_EVENTS(ch);

    GET_POINTS_EVENT(ch, 0) = NULL;
    GET_POINTS_EVENT(ch, 1) = NULL;
    GET_POINTS_EVENT(ch, 2) = NULL;
    GET_POINTS_EVENT(ch, 3) = NULL;
    GET_ACTION(ch) = NULL;
    GET_DAMAGE_EVENTS(ch) = NULL;

    for (pos = 0; pos < NUM_WEARS; pos++) {
      if (obj[pos])
	equip_char(ch, obj[pos], pos);
    }

    extract_char(newmob);
  }
#endif
}





/* modifies the target's hit points */
ACMD(do_mdamage)
{
    if (!MOB_OR_IMPL(ch)) {
	send_to_char("Huh?!?\r\n", ch);
	return;
    }
    if (AFF_FLAGGED(ch, AFF_CHARM))
	return;
  
    if (ch->desc && (GET_TRUST(ch->desc->original) < TRUST_IMPL))
	return;  

    do_scriptdamage((game_data *) ch, argument, cmd, subcmd, IN_ROOM(ch));
}


