/**************************************************************************
*  File: objcmd.c                                                         *
*  Usage: contains the command_interpreter for objects,                   *
*         object commands.                                                *
*                                                                         *
*                                                                         *
*  $Author: tlo $
*  $Date: 1999/03/06 18:27:07 $
*  $Revision: 6.11 $
**************************************************************************/

#include "conf.h"
#include "sysdep.h"


#include "structs.h"
#include "screen.h"
#include "scripts.h"
#include "index.h"
#include "utils.h"
#include "comm.h"
#include "interpreter.h"
#include "find.h"
#include "handler.h"
#include "db.h"
#include "events.h"

void die(struct char_data *ch, struct char_data *killer);
extern int genscript_command_interpreter(game_data * thing, char *argument, int cmd = 0);

#define OCMD(name)  \
   void (name)(obj_data *obj, char *argument, int cmd, int subcmd)


/* do_osend */
#define SCMD_OSEND         0
#define SCMD_OECHOAROUND   1



/* attaches object name and vnum to msg and sends it to script_log */
void obj_log(obj_data * obj, char *msg)
{
    char buf[MAX_INPUT_LENGTH + 100];

    void script_log(char *msg);

    sprintf(buf, "Obj (%s, VNum %d): %s",
	    ss_data(obj->short_description), GET_OBJ_NUM(obj), msg);
    script_log(buf);
}


/* returns the real room number, or NOWHERE if not found or invalid */
sh_int find_obj_target_room(obj_data * obj, char *rawroomstr)
{
    int tmp;
    sh_int location;
    char_data *target_mob;
    obj_data *target_obj;
    char roomstr[MAX_INPUT_LENGTH];

    one_argument(rawroomstr, roomstr);

    if (!*roomstr)
	return NOWHERE;

  if (isdigit(*roomstr) && !strchr(roomstr, '.')) {
	tmp = atoi(roomstr);
	if ((location = real_room(tmp)) < 0)
	    return NOWHERE;
  } else if ((target_mob = get_char_by_obj(obj, roomstr)))
	location = IN_ROOM(target_mob);
  else if ((target_obj = get_obj_by_obj(obj, roomstr))) {
	if (target_obj->in_room != NOWHERE)
	    location = target_obj->in_room;
	else 
	    return NOWHERE;
  } else
	return NOWHERE;
  
    /* a room has been found.  Check for permission */
    if (ROOM_FLAGGED(location, ROOM_GODROOM) || 
	ROOM_FLAGGED(location, ROOM_HOUSE))
	return NOWHERE;

    if (ROOM_FLAGGED(location, ROOM_PRIVATE) &&
	world[location]->people && world[location]->people->next_in_room)
	return NOWHERE;

    return location;
}



/* Object commands */

// Most of these are simple wrapper functions now.  Why keep them?  Because 
// keeping object script commands may allow useful techniques in scripts.


OCMD(do_oecho)
{
    do_scriptecho((game_data *) obj, argument, cmd, subcmd, obj->InRoom());
}


OCMD(do_oforce)
{
    do_scriptforce((game_data *) obj, argument, cmd, subcmd, obj->InRoom());
}


OCMD(do_osend)
{
    do_scriptsend((game_data *) obj, argument, cmd, subcmd, obj->InRoom());
}

/* increases the target's exp */
OCMD(do_oexp)
{
    do_scriptexp((game_data *) obj, argument, cmd, subcmd, obj->InRoom());
}


/* transform into a different object */
/* note: this shouldn't be used with containers unless both objects */
/* are containers! */


OCMD(do_otransform)
{
    do_scripttransform((game_data *) obj, argument, cmd, subcmd, obj->InRoom());
}


/* purge all objects an npcs in room, or specified object or mob */
OCMD(do_opurge)
{
    do_scriptpurge((game_data *) obj, argument, cmd, subcmd, obj->InRoom());
}


OCMD(do_oteleport)
{
    do_scriptteleport((game_data *) obj, argument, cmd, subcmd, obj->InRoom());
}


OCMD(do_oload)
{
    do_scriptload((game_data *) obj, argument, cmd, subcmd, obj->InRoom());
}

OCMD(do_odamage)
{
    do_scriptdamage((game_data *) obj, argument, cmd, subcmd, obj->InRoom());
}

const struct obj_command_info obj_cmd_info[] =
{
  {"RESERVED", 0, 0},		/* this must be first -- for specprocs */

  {"oecho", do_oecho, 0},
  {"oechoaround", do_osend, SCMD_OECHOAROUND},
  {"oexp", do_oexp, 0},
  {"oforce", do_oforce, 0},
  {"oload", do_oload, 0},
  {"opurge", do_opurge, 0},
  {"osend", do_osend, SCMD_OSEND},
  {"oteleport", do_oteleport, 0},
  {"odamage", do_odamage, 0},
  {"otransform", do_otransform, 0},
    
  {"\n", 0, 0}			/* this must be last */
};



/*
 *  This is the command interpreter used by objects, called by script_driver.
 */
void obj_command_interpreter(obj_data * obj, char *argument, int cmd = 0)
{
    int length;
    char *line, arg[MAX_INPUT_LENGTH];

    if (obj->InRoom() <= NOWHERE)
      return;
  
    if (!cmd && genscript_command_interpreter((game_data *) obj, argument, -1)) {
      return;
    }
  
    skip_spaces(&argument);
  
    /* just drop to next line for hitting CR */
    if (!*argument || PURGED(obj))
	return;

    line = any_one_arg(argument, arg);


  if (cmd <= 0) {
    /* find the command */
    cmd = 0;
    for (length = strlen(arg); *obj_cmd_info[cmd].command != '\n'; ++cmd)
      if (!strncmp(obj_cmd_info[cmd].command, arg, length))
	break;
  }
  
  if (*obj_cmd_info[cmd].command == '\n') {
	sprintf(buf2, "Unknown object cmd: '%s'", argument);
	obj_log(obj, buf2);
  } else
	((*obj_cmd_info[cmd].command_pointer) 
	 (obj, line, cmd, obj_cmd_info[cmd].subcmd));
}
