/************************************************************************
 * OasisOLC - oedit.c						v1.5	*
 * Copyright 1996 Harvey Gilpin.					*
 * Original author: Levork						*
 ************************************************************************/

#include "conf.h"
#include "sysdep.h"

#include "structs.h"
#include "scripts.h"
#include "index.h"
#include "comm.h"
#include "spells.h"
#include "utils.h"
#include "db.h"
#include "boards.h"
#include "olc.h"
#include "constants.h"
#include "events.h"
#include "spec.h"

/*------------------------------------------------------------------------*/

/*
 * External variable declarations.
 */

extern char *spells[];

extern void edit_extradesc(char_data *ch, struct extra_descr_data *ed);

/*------------------------------------------------------------------------*/

/*
 * Handy macros.
 */
#define S_PRODUCT(s, i) ((s)->producing[(i)])
#define PROTO_OBJ(num) ((obj_data *) obj_index[(num)]->proto)
#define OBJTYPE_PROMPT (obj_values_tab[GET_OBJ_TYPE(OLC_OBJ(ch))][OLC_MENU(ch) - OEDIT_VALUE_1].prompt)
/*------------------------------------------------------------------------*/

void oedit_disp_container_flags_menu(char_data *ch);
void oedit_disp_extradesc_menu(char_data *ch);
void oedit_disp_weapon_menu(char_data *ch);
void oedit_disp_val_menu(char_data *ch);
void oedit_disp_type_menu(char_data *ch);
void oedit_disp_extra_menu(char_data *ch);
void oedit_disp_wear_menu(char_data *ch);
void oedit_disp_menu(char_data *ch);

void oedit_parse(char_data *ch, char *arg);
void oedit_disp_spells_menu(char_data *ch);
void oedit_liquid_type(char_data *ch);
void oedit_setup_new(char_data *ch, int copyfrom);
void oedit_setup_existing(char_data *ch, int copyfrom);
void oedit_save_to_disk(int zone);
void oedit_save_internally(char_data *ch);

extern void olc_disp_specproc_menu(char_data *ch);
extern void olc_edit_special(char_data *ch, char *argument);
extern void erase_exdesc(struct extra_descr_data **head, struct extra_descr_data **target);

/*------------------------------------------------------------------------*\
  Utility and exported functions
\*------------------------------------------------------------------------*/

void oedit_setup_new(char_data *ch, int copyfrom)
{
  extern void init_obj_proto(obj_data *obj);

  if (!copyfrom) {
    OLC_OBJ(ch) = new obj_data;
    init_obj_proto(OLC_OBJ(ch));
    OLC_SAVE(ch) = OLC_SAVE_NO;
  } else {
//    OLC_OBJ(ch) = read_object(copyfrom);
    OLC_OBJ(ch) = new obj_data;
    OLC_OBJ(ch)->copyover(PROTO_OBJ(copyfrom));
    OLC_SCRIPT(ch) = new script_data;
    OLC_SCRIPT(ch)->copyintlist(obj_index[copyfrom]->triggers);
    OLC_SAVE(ch) = OLC_SAVE_COPY;
  }

  GET_OBJ_NUM(OLC_OBJ(ch)) = OLC_NUM(ch);
  oedit_disp_menu(ch);
}
/*------------------------------------------------------------------------*/

void oedit_setup_existing(char_data *ch, int copyfrom)
{   
  if (!copyfrom) {
    OLC_OBJ(ch) = new obj_data(PROTO_OBJ(OLC_NUM(ch)));
    OLC_SCRIPT(ch) = new script_data;
    OLC_SCRIPT(ch)->copyintlist(obj_index[OLC_NUM(ch)]->triggers);
    OLC_SAVE(ch) = OLC_SAVE_NO;
  } else {
    OLC_OBJ(ch) = new obj_data;
    OLC_OBJ(ch)->copyover(PROTO_OBJ(copyfrom));
    OLC_SCRIPT(ch) = new script_data;
    OLC_SCRIPT(ch)->copyintlist(obj_index[copyfrom]->triggers);
    OLC_SAVE(ch) = OLC_SAVE_OVERWRITE;
  }

  GET_OBJ_NUM(OLC_OBJ(ch)) = OLC_NUM(ch);

  oedit_disp_menu(ch);
}

/*------------------------------------------------------------------------*/

#define ZCMD zone_table[zone].cmd[cmd_no]

void oedit_save_internally(char_data *ch)
{
  obj_data *previous = NULL;

  
  if (OLC_OBJ(ch)->action_description) {
    strcpy (buf3, ss_data(OLC_OBJ(ch)->action_description));
    if (strlen(buf3) == 0) {
      ss_free(OLC_OBJ(ch)->action_description);
      OLC_OBJ(ch)->action_description = NULL;
    }
  }

  /* write to internal tables */
  if (obj_index[OLC_NUM(ch)]) {
    /* now safe to free old proto and write over */
    // FREE (obj_index[OLC_NUM(ch)]->proto);
    delete obj_index[OLC_NUM(ch)]->proto;
    obj_index[OLC_NUM(ch)]->proto = OLC_OBJ(ch);
  } else {
    insert_obj_proto(OLC_OBJ(ch));
  }

  // Save the special procedures
  obj_index[OLC_NUM(ch)]->func = OLC_DATA(ch)->func;
  if (obj_index[OLC_NUM(ch)]->farg) {
    FREE(obj_index[OLC_NUM(ch)]->farg);
  }
  obj_index[OLC_NUM(ch)]->farg = OLC_DATA(ch)->farg;
  OLC_DATA(ch)->farg = NULL;

  free_int_list(obj_index[OLC_NUM(ch)]->triggers);
  obj_index[OLC_NUM(ch)]->triggers = NULL;
  if (OLC_SCRIPT(ch) && TRIGGERS(OLC_SCRIPT(ch)))
    obj_index[OLC_NUM(ch)]->triggers = script_to_int_list(OLC_SCRIPT(ch));

  OLC_OBJ(ch) = NULL;
  olc_add_to_save_list(zone_table[OLC_ZNUM(ch)].number, OLC_OEDIT);
}

/*------------------------------------------------------------------------*/

/**************************************************************************
 Menu functions 
 **************************************************************************/

/*
 * For container flags.
 */
void oedit_disp_container_flags_menu(char_data *ch)
{
  sprintbit(GET_OBJ_VAL(OLC_OBJ(ch), 1), container_bits, buf1);
#if defined(CLEAR_SCREEN)
  send_to_char("[H[J", ch);
#endif
  sprintf(buf,
	  "&cG1&c0) CLOSEABLE\r\n"
	  "&cG2&c0) PICKPROOF\r\n"
	  "&cG3&c0) CLOSED\r\n"
	  "&cG4&c0) LOCKED\r\n"
	  "Container flags: &cC%s&c0\r\n"
	  "Enter flag, 0 to quit : ", buf1);
  send_to_char(buf, ch);
}

/*
 * For extra descriptions.
 */
void oedit_disp_extradesc_menu(char_data *ch)
{
  struct extra_descr_data *extra_desc = OLC_DESC(ch);

  strcpy(buf1, !extra_desc->next ? "<Not set>" : "<Set>");

#if defined(CLEAR_SCREEN)
  send_to_char("[H[J", ch);
#endif
  sprintf(buf,
	  "Extra desc menu\r\n"
	  "&cG1&c0) Keyword: &cY%s\r\n"
	  "&cG2&c0) Description:\r\n&cY%s\r\n"
	  "&cG3&c0) Goto next description: %s\r\n"
	  "&cG4&c0) Erase this description\r\n"
	  "&cG0&c0) Quit\r\n"
	  "Enter choice : ",

     	  extra_desc->keyword ? ss_data(extra_desc->keyword) : "<NONE>",
	  extra_desc->description ? ss_data(extra_desc->description) : "<NONE>",
	  buf1);
  send_to_char(buf, ch);
  OLC_MENU(ch) = OEDIT_EXTRADESC_MENU;
}

/*
 * Ask for *which* apply to edit.
 */
void oedit_disp_prompt_apply_menu(char_data *ch)
{
  int counter;

#if defined(CLEAR_SCREEN)
  send_to_char("[H[J", ch);
#endif
  for (counter = 0; counter < MAX_OBJ_AFFECT; counter++) {
    if (OLC_OBJ(ch)->affected[counter].modifier) {
      sprinttype(OLC_OBJ(ch)->affected[counter].location, apply_types, buf2);
      sprintf(buf, " &cG%d&c0) %+d to %s\r\n", counter + 1, 
	      OLC_OBJ(ch)->affected[counter].modifier, buf2);
      send_to_char(buf, ch);
    } else {
      sprintf(buf, " &cG%d&c0) None.\r\n", counter + 1);
      send_to_char(buf, ch);
    }
  }
  send_to_char("\r\nEnter affection to modify (0 to quit) : ", ch);
  OLC_MENU(ch) = OEDIT_PROMPT_APPLY;
}

/*
 * Ask for liquid type.
 */
void oedit_liquid_type(char_data *ch)
{
  int counter, columns = 0;

#if defined(CLEAR_SCREEN)
  send_to_char("[H[J", ch);
#endif
  for (counter = 0; counter < NUM_LIQ_TYPES; counter++) {
    sprintf(buf, " &cG%2d&c0) &cY%-20.20s %s", counter,
	    drinks[counter], !(++columns % 2) ? "\r\n" : "");
    send_to_char(buf, ch);
  }
  sprintf(buf, "\r\n&c0Enter drink type : ");
  send_to_char(buf, ch);
  OLC_MENU(ch) = OEDIT_VALUE_3;
}

/*
 * The actual apply to set.
 */
void oedit_disp_apply_menu(char_data *ch)
{
  int counter, columns = 0;

#if defined(CLEAR_SCREEN)
  send_to_char("[H[J", ch);
#endif
  for (counter = 0; counter < NUM_APPLIES; counter++) {
    sprintf(buf, "&cG%2d&c0) %-20.20s %s", counter, 
		apply_types[counter], !(++columns % 2) ? "\r\n" : "");
    send_to_char(buf, ch);
  }
  send_to_char("\r\nEnter apply type (0 is no apply) : ", ch);
  OLC_MENU(ch) = OEDIT_APPLY;
}

/*
 * Weapon type.
 */
void oedit_disp_weapon_menu(char_data *ch)
{
  int counter, columns = 0;

#if defined(CLEAR_SCREEN)
  send_to_char("[H[J", ch);
#endif
  for (counter = FIRST_WEAPON_PROFICIENCY; counter <= LAST_WEAPON_PROFICIENCY; ++counter) 
  { sprintf(buf, "&cG%2d&c0) %-20.20s ",
	    counter, spells[counter]
    );
    if(!(++columns % 2))
      strcat(buf, "\r\n");
    send_to_char(buf, ch);
  }
  send_to_char("\r\nEnter weapon type : ", ch);
}

/*
 * Spell type.
 */
void oedit_disp_spells_menu(char_data *ch)
{
  int counter, columns = 0;

#if defined(CLEAR_SCREEN)
  send_to_char("[H[J", ch);
#endif
  for (counter = 0; counter < NUM_SPELLS; counter++) {
    sprintf(buf, "&cG%2d&c0) &cY%-20.20s %s", counter,
		spells[counter], !(++columns % 3) ? "\r\n" : "");
    send_to_char(buf, ch);
  }
  sprintf(buf + strlen(buf), "\r\nEnter spell choice (0 for none) : ");
  send_to_char(buf, ch);
}


#ifdef GOT_RID_OF_IT
// Generic object value editing by Daniel Houghton
void oedit_disp_val_menu(char_data *ch)
{
  byte objtype = GET_OBJ_TYPE(OLC_OBJ(ch));
  byte objval = OLC_MENU(ch) - OEDIT_VALUE_1;

  while (*obj_values_tab[objtype][objval].prompt == '\n') {
    ++objval;
    if (objval >= NUM_OBJ_VALUES) {
      OLC_MENU(ch) = OEDIT_MAIN_MENU;
      oedit_disp_menu(ch);
      return;
    }
  }

  OLC_MENU(ch) = OEDIT_VALUE_1 + objval;
  oasis_gen_edit(ch, "", OLC_MENU(ch), "");
  send_to_charf(ch, "%s ? ", obj_values_tab[objtype][objval].prompt);
}
#endif


// Generic object value editing by Daniel Houghton
void oedit_disp_val_menu(char_data *ch)
{
  char selection[80], *ptr;
  byte objtype = GET_OBJ_TYPE(OLC_OBJ(ch));
  byte objval = 0;
  const char **values = NULL;
  
  // *buf = '\0';

  strcpy(buf, "&cYObject Values&c0\r\n\n");

  while (objval < NUM_OBJ_VALUES) {
    if (*obj_values_tab[objtype][objval].prompt != '\n') {
      strcpy(selection, obj_values_tab[objtype][objval].prompt);
      if ((ptr = strchr(selection, '(')) != NULL)
   	*ptr = '\0';
    
      sprintf(buf + strlen(buf), "&cG%d&c0) %-30s : ", 
              objval + 1, selection);
	      
      values = obj_values_tab[objtype][objval].values;
  
      switch (obj_values_tab[objtype][objval].type) {
      case EDK_VALUE:
      case EDK_SPELLVALUE:
        if (GET_OBJ_VAL(OLC_OBJ(ch), objval) < 0)
  	  strcat(buf, "&cC-\r\n");
	else {
  	  sprintf(buf + strlen(buf), "&cC%s\r\n", 
	          values[GET_OBJ_VAL(OLC_OBJ(ch), objval)]);
	}
    break;
      case EDK_DIFFVALUE:
        if (GET_OBJ_VAL(OLC_OBJ(ch), objval) < 0)
  	  strcat(buf, "&cC-\r\n");
	else {
  	  sprintf(buf + strlen(buf), "&cC%s\r\n", 
	          values[GET_OBJ_VAL(OLC_OBJ(ch), objval) + 
		  obj_values_tab[objtype][objval].min]);
  }
    break;
  default:
  	sprintf(buf + strlen(buf), "&cC%d\r\n", 
	        GET_OBJ_VAL(OLC_OBJ(ch), objval));
	break;
      }
    }
    ++objval;
  }

  send_to_char(buf, ch);

  send_to_char("&c0\r\n&cGQ&c0) Quit\r\n"
               "Enter choice : ", ch);

  OLC_MENU(ch) = OEDIT_VALUE_MENU;
}


/*
 * Object extra flags.
 */
void oedit_disp_extra_menu(char_data *ch)
{
#if defined(CLEAR_SCREEN)
  send_to_char("[H[J", ch);
#endif
  oasis_gen_edit(ch, "", OEDIT_EXTRAS, "");
  sprintbit(GET_OBJ_EXTRA(OLC_OBJ(ch)), extra_bits, buf1);
  sprintf(buf, "\r\nObject flags: &cC%s&c0\r\n"
	  "Enter object extra flag (0 to quit) : ",
	  buf1);
  send_to_char(buf, ch);
}

/*
 * Object wear flags.
 */
void oedit_disp_wear_menu(char_data *ch)
{
#if defined(CLEAR_SCREEN)
  send_to_char("[H[J", ch);
#endif
  oasis_gen_edit(ch, "", OEDIT_WEAR, "");
  sprintbit(GET_OBJ_WEAR(OLC_OBJ(ch)), wear_bits, buf1);
  sprintf(buf, "\r\nWear flags: &cC%s&c0\r\n"
	  "Enter wear flag, 0 to quit : ", buf1);
  send_to_char(buf, ch);
}

/*
 * Display main menu.
 */
void oedit_disp_menu(char_data *ch)
{
  struct obj_data *obj;

  obj = OLC_OBJ(ch);

  /*
   * Build buffers for first part of menu.
   */
  sprinttype(GET_OBJ_TYPE(obj), item_types, buf1);
  sprintbit(GET_OBJ_EXTRA(obj), extra_bits, buf2);

  /*
   * Build first half of menu.
   */
  sprintf(buf,
#if defined(CLEAR_SCREEN)
	  "[H[J"
#endif
          "-- Item number : [&cC%d&c0]   %s %s\r\n"
	  "&cG1&c0) Namelist : &cY%s\r\n"
	  "&cG2&c0) S-Desc   : &cY%s\r\n"
	  "&cG3&c0) L-Desc   :-\r\n&cY%s\r\n"
	  "&cG4&c0) A-Desc   :-\r\n&cY%s"
	  "&cG5&c0) Type        : &cC%s\r\n"
	  "&cG6&c0) Extra flags : &cC%s\r\n",

	  OLC_NUM(ch), 
          (OLC_SAVE(ch) == OLC_SAVE_COPY) ? "&cW&bb[ Copy ]&c0" : "",
          (OLC_SAVE(ch) == OLC_SAVE_OVERWRITE) ? "&cW&br[ OVERWRITING ]&c0" : "",
#ifdef GOT_RID_OF_IT
	  (obj->name && *obj->name) ? obj->name : "undefined",
	  (obj->short_description && *obj->short_description) ? obj->short_description : "undefined",
	  (obj->description && *obj->description) ? obj->description : "undefined",
	  (obj->action_description && *obj->action_description) ? obj->action_description : "<not set>\r\n",
#endif
	  ss_data(obj->name),
 	  ss_data(obj->short_description),
	  ss_data(obj->description),
	  obj->action_description ? ss_data(obj->action_description) : "<not set>\r\n",
	  buf1,
	  buf2);
  /*
   * Send first half.
   */
  send_to_char(buf, ch);

  /*
   * Build second half of menu.
   */
  sprintbit(GET_OBJ_WEAR(obj), wear_bits, buf1);
  sprintf(buf,
	  "&cG7&c0) Wear flags  : &cC%s\r\n"
	  "&cG8&c0) Weight      : &cC%d\r\n"
	  "&cG9&c0) Cost        : &cC%d\r\n"
	  "&cGA&c0) Cost/Day    : &cC%d\r\n"
//	  "&cGB&c0) Timer       : &cC%d\r\n"
	  "&cGC&c0) Passive Defense : &cC%d\r\n"
	  "&cGD&c0) Damage Resist   : &cC%d\r\n"
	  "&cGE&c0) Material        : &cC%s\r\n"
	  "&cGF&c0) Values          : &cC%d %d %d %d %d %d %d %d\r\n"
	  "&cGG&c0) Applies menu\r\n"
	  "&cGH&c0) Extra descriptions menu\r\n"
	  "&cGP&c0) Special procedure : &cC%s\r\n"
          "&cGS&c0) Script attachments\r\n"
	  "&cGQ&c0) Quit\r\n"
	  "Enter choice : ",

	  buf1,
	  GET_OBJ_WEIGHT(obj),
	  GET_OBJ_COST(obj),
	  GET_OBJ_RENT(obj),
//	  GET_OBJ_TIMER(obj),
	  GET_OBJ_PD(obj),
	  GET_OBJ_DR(obj),
	  material_types[GET_OBJ_MATERIAL(obj)],
	  GET_OBJ_VAL(obj, 0),
	  GET_OBJ_VAL(obj, 1),
	  GET_OBJ_VAL(obj, 2),
	  GET_OBJ_VAL(obj, 3),
	  GET_OBJ_VAL(obj, 4),
	  GET_OBJ_VAL(obj, 5),
	  GET_OBJ_VAL(obj, 6),
	  GET_OBJ_VAL(obj, 7),
	  (OLC_DATA(ch)->func == NULL) ? "None" : spec_obj_name (OLC_DATA(ch)->func)

//	  "Unsupported"
	  );
  send_to_char(buf, ch);
  OLC_MENU(ch) = OEDIT_MAIN_MENU;
}

/***************************************************************************
 main loop (of sorts).. basically interpreter throws all input to here
 ***************************************************************************/

void oedit_parse(char_data *ch, char *arg)
{
  int number, max_val, min_val;

  switch (OLC_MENU(ch)) {

  case OEDIT_CONFIRM_SAVESTRING:
    switch (*arg) {
    case 'y':
    case 'Y':
      send_to_char("Saving object to memory.\r\n", ch);
      oedit_save_internally(ch);
      sprintf(buf, "OLC: %s edits obj %d", GET_NAME(ch), OLC_NUM(ch));
      mudlog(buf, CMP, MAX(TRUST_CREATOR, GET_INVIS_LEV(ch)), TRUE);
      cleanup_olc(ch, CLEANUP_STRUCTS);
      return;
    case 'n':
    case 'N':
      /*
       * Cleanup all.
       */
      cleanup_olc(ch, CLEANUP_ALL);
      return;
    default:
      send_to_char("Invalid choice!\r\n", ch);
      switch (OLC_SAVE(ch)) {
      case OLC_SAVE_COPY:
        send_to_char("&cYDo you wish to save this copied object internally? : &c0", ch);
        break;
      case OLC_SAVE_OVERWRITE:
        send_to_char("&cRYou're about to copy over a previously existing object!\a&c0\r\n", ch);
      default:
        send_to_char("Do you wish to save this object internally? : ", ch);
      }
      return;
    }

  case OEDIT_MAIN_MENU:
    /*
     * Throw us out to whichever edit mode based on user input.
     */
    switch (*arg) {
    case 'q':
    case 'Q':
      if (OLC_SAVE(ch)) { /*. Something has been modified .*/
        switch (OLC_SAVE(ch)) {
        case OLC_SAVE_COPY:
          send_to_char("&cYDo you wish to save this copied object internally? : &c0", ch);
          break;
        case OLC_SAVE_OVERWRITE:
          send_to_char("&cRYou're about to copy over a previously existing object!\a&c0\r\n", ch);
        default:
          send_to_char("Do you wish to save this object internally? : ", ch);
        }
        OLC_MENU(ch) = OEDIT_CONFIRM_SAVESTRING;
      } else
	cleanup_olc(ch, CLEANUP_ALL);
      return;
    case '1':
      send_to_char("Enter namelist : ", ch);
      OLC_MENU(ch) = OEDIT_EDIT_NAMELIST;
      break;
    case '2':
      send_to_char("Enter short desc : ", ch);
      OLC_MENU(ch) = OEDIT_SHORTDESC;
      break;
    case '3':
      send_to_char("Enter long desc :-\r\n| ", ch);
      OLC_MENU(ch) = OEDIT_LONGDESC;
      break;
    case '4':
      send_to_char("Enter action description: (/s saves /h for help)\r\n\r\n", ch);
      oasis_gen_edit(ch, "", OEDIT_ACTDESC, "");
      if (!OLC_SAVE(ch))
        OLC_SAVE(ch) = OLC_SAVE_YES;
      break;
    case '5':
      oasis_gen_edit(ch, "", OEDIT_TYPE, "");
      send_to_char("Enter object type : ", ch);
      OLC_MENU(ch) = OEDIT_TYPE;
      break;
    case '6':
      // oedit_disp_extra_menu(ch);
      OLC_MENU(ch) = OEDIT_EXTRAS;
      oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      break;
    case '7':
      // oedit_disp_wear_menu(ch);
      OLC_MENU(ch) = OEDIT_WEAR;
      oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      break;
    case '8':
      send_to_char("Enter weight : ", ch);
      OLC_MENU(ch) = OEDIT_WEIGHT;
      break;
    case '9':
      send_to_char("Enter cost : ", ch);
      OLC_MENU(ch) = OEDIT_COST;
      break;
    case 'a':
    case 'A':
      send_to_char("Enter cost per day : ", ch);
      OLC_MENU(ch) = OEDIT_COSTPERDAY;
      break;
//     case 'b':
//     case 'B':
//       send_to_char("Enter timer : ", ch);
//       OLC_MENU(ch) = OEDIT_TIMER;
//       break;
    case 'c':
    case 'C':
      send_to_char("Enter passive defense : ", ch);
      OLC_MENU(ch) = OEDIT_PD;
      break;
    case 'd':
    case 'D':
      send_to_char("Enter damage resistance : ", ch);
      OLC_MENU(ch) = OEDIT_DR;
      break;
    case 'e':
    case 'E':
      oasis_gen_edit(ch, "", OEDIT_MATERIAL, "");
      send_to_char("Enter material type : ", ch);
      OLC_MENU(ch) = OEDIT_MATERIAL;
      break;
    case 'f':
    case 'F':
      /*
       * Clear any old values  
       */
      oedit_disp_val_menu(ch);
      break;
    case 'g':
    case 'G':
      oedit_disp_prompt_apply_menu(ch);
      break;
    case 'h':
    case 'H':
      /*
       * If extra descriptions don't exist.
       */
      if (!OLC_OBJ(ch)->ex_description) {
	CREATE(OLC_OBJ(ch)->ex_description, struct extra_descr_data, 1);
	OLC_OBJ(ch)->ex_description->next = NULL;
      }
      OLC_DESC(ch) = OLC_OBJ(ch)->ex_description;
      oedit_disp_extradesc_menu(ch);
      break;
    case 'p':
    case 'P':
      olc_disp_specproc_menu(ch);
      OLC_MENU(ch) = OEDIT_SPECPROC_MENU;
      return;
    case 's':
    case 'S':
      dg_script_menu(ch);
      return;
    default:
      oedit_disp_menu(ch);
      break;
    }
    return;			/*
				 * end of OEDIT_MAIN_MENU 
				 */

  case SCRIPT_MAIN_MENU:
  case SCRIPT_NEW_TRIGGER:
  case SCRIPT_DEL_TRIGGER:
    dg_script_edit_parse(ch, arg);
    return;

  case OEDIT_EDIT_NAMELIST:
    if (OLC_OBJ(ch)->name)
      ss_free(OLC_OBJ(ch)->name);
    OLC_OBJ(ch)->name = (arg && *arg) ? ss_create(arg) : ss_create("undefined");
    break;

  case OEDIT_SHORTDESC:
    if (OLC_OBJ(ch)->short_description)
      ss_free(OLC_OBJ(ch)->short_description);
    OLC_OBJ(ch)->short_description = ss_create(arg);
    break;

  case OEDIT_LONGDESC:
    if (OLC_OBJ(ch)->description)
      ss_free(OLC_OBJ(ch)->description);
    OLC_OBJ(ch)->description = ss_create(arg);
    break;

  case OEDIT_TYPE:
    oasis_gen_edit(ch, "", OEDIT_TYPE, arg);
    break;

  case OEDIT_EXTRAS:
  case OEDIT_WEAR:
    switch (*arg && oasis_gen_edit(ch, "", OLC_MENU(ch), arg)) {
      case 0: oedit_disp_menu(ch); return;
      default: 
        if (!OLC_SAVE(ch))
	  OLC_SAVE(ch) = OLC_SAVE_YES;
      oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      return;
    }

  case OEDIT_WEIGHT:
    GET_OBJ_WEIGHT(OLC_OBJ(ch)) = atoi(arg);
    break;

  case OEDIT_COST:
    GET_OBJ_COST(OLC_OBJ(ch)) = atoi(arg);
    break;

  case OEDIT_COSTPERDAY:
    GET_OBJ_RENT(OLC_OBJ(ch)) = atoi(arg);
    break;

  case OEDIT_PD:
  case OEDIT_DR:
  case OEDIT_MATERIAL:
    if (*arg) {
      if (!OLC_SAVE(ch))
        OLC_SAVE(ch) = OLC_SAVE_YES;
      oasis_gen_edit(ch, "", OLC_MENU(ch), arg);
    }
    OLC_MENU(ch) = OEDIT_MAIN_MENU;
    oedit_disp_menu(ch);
    return;

#ifdef GOT_RID_OF_IT
  case OEDIT_TIMER:
    GET_OBJ_TIMER(OLC_OBJ(ch)) = atoi(arg);
    break;
#endif

  case OEDIT_VALUE_1:
  case OEDIT_VALUE_2:
  case OEDIT_VALUE_3:
  case OEDIT_VALUE_4:
  case OEDIT_VALUE_5:
  case OEDIT_VALUE_6:
  case OEDIT_VALUE_7:
  case OEDIT_VALUE_8:
    switch (*arg) {
    case '\0':
    case 'q':
    case 'Q': oedit_disp_val_menu(ch); return;
      }
        if (!OLC_SAVE(ch))
          OLC_SAVE(ch) = OLC_SAVE_YES;
    oasis_gen_edit(ch, "", OLC_MENU(ch), arg); 
    oedit_disp_val_menu(ch);
    return;

  case OEDIT_PROMPT_APPLY:
    if ((number = atoi(arg)) == 0)
      break;
    else if (number < 0 || number > MAX_OBJ_AFFECT) {
      oedit_disp_prompt_apply_menu(ch);
      return;
    }
    OLC_VAL(ch) = number - 1;
    OLC_MENU(ch) = OEDIT_APPLY;
    oedit_disp_apply_menu(ch);
    return;

  case OEDIT_APPLY:
    if ((number = atoi(arg)) == 0) {
      OLC_OBJ(ch)->affected[OLC_VAL(ch)].location = 0;
      OLC_OBJ(ch)->affected[OLC_VAL(ch)].modifier = 0;
      oedit_disp_prompt_apply_menu(ch);
    } else if (number < 0 || number >= NUM_APPLIES)
      oedit_disp_apply_menu(ch);
    else {
      OLC_OBJ(ch)->affected[OLC_VAL(ch)].location = number;
      send_to_char("Modifier : ", ch);
      OLC_MENU(ch) = OEDIT_APPLYMOD;
    }
    return;

  case OEDIT_APPLYMOD:
    OLC_OBJ(ch)->affected[OLC_VAL(ch)].modifier = atoi(arg);
    oedit_disp_prompt_apply_menu(ch);
    return;

  case OEDIT_SPECPROC_MENU:
    if (*arg) {
      olc_edit_special(ch, arg);
      oedit_disp_menu(ch);
      OLC_SAVE(ch) = OLC_SAVE_YES;
    } else {
      oedit_disp_menu(ch);
    }
    return;

  case OEDIT_EXTRADESC_KEY:
    if (OLC_DESC(ch)->keyword)
      ss_free(OLC_DESC(ch)->keyword);
    OLC_DESC(ch)->keyword = (arg && *arg) ? ss_create(arg) : 
                            ss_create("undefined");
    oedit_disp_extradesc_menu(ch);
    return;

  case OEDIT_EXTRADESC_MENU:
    if (!*arg) {
      oedit_disp_extradesc_menu(ch);
      return;
    }
    switch ((number = atoi(arg))) {
    case 0:
      if (!OLC_DESC(ch)->keyword || !OLC_DESC(ch)->description) {
	struct extra_descr_data **tmp_desc;

	if (OLC_DESC(ch)->keyword)
	  free(OLC_DESC(ch)->keyword);
	if (OLC_DESC(ch)->description)
	  free(OLC_DESC(ch)->description);

	/*
	 * Clean up pointers  
	 */
	for (tmp_desc = &(OLC_OBJ(ch)->ex_description); *tmp_desc;
	     tmp_desc = &((*tmp_desc)->next)) {
	  if (*tmp_desc == OLC_DESC(ch)) {
	    *tmp_desc = NULL;
	    break;
	  }
	}
	free(OLC_DESC(ch));
      }
    break;

    case 1:
      OLC_MENU(ch) = OEDIT_EXTRADESC_KEY;
      send_to_char("Enter keywords, separated by spaces :-\r\n| ", ch);
      return;

    case 2:
      send_to_char("Enter extra description: (/s saves /h for help)\r\n\r\n", ch);
      edit_extradesc(ch, OLC_DESC(ch));
      if (!OLC_SAVE(ch))
        OLC_SAVE(ch) = OLC_SAVE_YES;
      return;

    case 3:
      /*
       * Only go to the next description if this one is finished.
       */
      if (OLC_DESC(ch)->keyword && OLC_DESC(ch)->description) {
	struct extra_descr_data *new_extra;

	if (OLC_DESC(ch)->next)
	  OLC_DESC(ch) = OLC_DESC(ch)->next;
	else {	/* Make new extra description and attach at end. */
	  CREATE(new_extra, struct extra_descr_data, 1);
	  OLC_DESC(ch)->next = new_extra;
	  OLC_DESC(ch) = OLC_DESC(ch)->next;
	}
      }
      oedit_disp_extradesc_menu(ch);
      return;
    case 4:
      // Wipe out this description
      erase_exdesc(&OLC_OBJ(ch)->ex_description, &OLC_DESC(ch));
      oedit_disp_menu(ch);
      return;
      /*
       * No break - drop into default case.
       */
    default:
      oedit_disp_extradesc_menu(ch);
      return;
    }
    break;
  case OEDIT_VALUE_MENU:
    switch (*arg) {
    case '0':
    case 'q':
    case 'Q': oedit_disp_menu(ch); return;
    }
  
    number = atoi(arg);

    if ((number >= 1) && (number <= 8)) {
      OLC_MENU(ch) = OEDIT_VALUE_1 - 1 + number;
      if (*OBJTYPE_PROMPT == '\n') {
        oedit_disp_val_menu(ch); return;
      }
      oasis_gen_edit(ch, "", OLC_MENU(ch), ""); 
      send_to_charf(ch, "Enter value - %s : ", OBJTYPE_PROMPT);
      return;
    }
    break;
  
  default:
    mudlog("SYSERR: OLC: Reached default case in oedit_parse()!", BRF, TRUST_CREATOR, TRUE);
    send_to_char("Oops...\r\n", ch);
    break;
  }

  /*
   * If we get here, we have changed something.  
   */
  if (!OLC_SAVE(ch))
    OLC_SAVE(ch) = OLC_SAVE_YES;
  oedit_disp_menu(ch);
}
