/************************************************************************
 * OasisOLC - olc.h					      v1.5    *
 *								      *
 * Copyright 1996 Harvey Gilpin.				      *
 ************************************************************************/

#ifndef OASIS_OLC
#define OASIS_OLC
#endif

/*
 * If you don't want a short explanation of each field in your zone files,
 * change the number below to a 0 instead of a 1.
 */
#if 0
#define ZEDIT_HELP_IN_FILE
#endif

/*
 * If you want to clear the screen before certain Oasis menus, set to 1.
 */
#if 0
#define CLEAR_SCREEN  1
#endif

/*
 * Macros, defines, structs and globals for the OLC suite.
 */

#define NUM_ROOM_FLAGS  	      16

#define NUM_MOB_FLAGS	      18
#define NUM_AFF_FLAGS	      22
#define NUM_ATTACK_TYPES      15

/* #define NUM_ITEM_TYPES  	      24 */
#define NUM_ITEM_FLAGS  	      17
#define NUM_ITEM_WEARS  	      15
#define NUM_APPLIES	      25
#define NUM_LIQ_TYPES		      16
#define NUM_POSITIONS	      15
#define NUM_SPELLS	      51

#define NUM_GENDERS	      3
#define NUM_SHOP_FLAGS  	      2
#define NUM_TRADERS	      7

/*
 * Define this to how many MobProg scripts you have.
 */
#define NUM_PROGS	      12

#define LVL_BUILDER	      LVL_GOD

/*
 * Utilities exported from olc.c.
 */
void strip_string(char *);
void cleanup_olc(char_data *ch, byte cleanup_type);
// void get_char_cols(struct char_data *ch);
void olc_add_to_save_list(int zone, byte type);
void olc_remove_from_save_list(int zone, byte type);

extern void oedit_parse(char_data *ch, char *arg);
extern void redit_parse(char_data *ch, char *arg);
extern void zedit_parse(char_data *ch, char *arg);
extern void medit_parse(char_data *ch, char *arg);
extern void sedit_parse(char_data *ch, char *arg);
extern void trigedit_parse(char_data *ch, char *arg);

/*
 * OLC structures.
 */

struct olc_data {
  int menu;
//  int zone_num;
  int number;
  int value;
  int save;
  struct char_data *mob;
  struct room_data *room;
  struct obj_data *obj;
  struct zone_data *zone;
  struct shop_data *shop;
  struct extra_descr_data *desc;
//  int last_olc_targ;           /* olc control                          */
//  int last_olc_mode;		/* olc control				*/
  struct trig_data *trig;
  int script_mode;
  int trigger_position;
  int item_type;
  struct script_data *script;
  SpecProc func;
  char *farg;		// For storage of specproc arguments
  char *storage;	// For storage of scripts
};

struct olc_save_info {
  int zone;
  char type;
  struct olc_save_info *next;
};

/*
 * Exported globals.
 */

extern struct olc_save_info *olc_save_list;
extern int find_owner_zone(int number); // from act.olc.c

/*
 * Descriptor access macros.
 */
#define OLC_DATA(ch)   ((ch)->player_specials->olc)	 /* Room/Obj VNUM.	 */
#define OLC_MENU(ch)   ((OLC_DATA(ch))->menu)	   /* Room/Obj VNUM.	   */
#define OLC_NUM(ch)    ((OLC_DATA(ch))->number)      /* Room/Obj VNUM.       */
#define OLC_VAL(ch)    ((OLC_DATA(ch))->value)       /* Scratch variable.    */
#define OLC_SAVE(ch)   ((OLC_DATA(ch))->save)       /* Scratch variable.    */
#define OLC_ZNUM(ch)   (find_owner_zone(OLC_NUM(ch)))    /* Real zone number.    */
#define OLC_ROOM(ch)   ((OLC_DATA(ch))->room)        /* Room structure.      */
#define OLC_OBJ(ch)    ((OLC_DATA(ch))->obj)	      /* Object structure.    */
#define OLC_ZONE(ch)   ((OLC_DATA(ch))->zone)      /* Zone structure.      */
#define OLC_MOB(ch)    ((OLC_DATA(ch))->mob)	      /* Mob structure.       */
#define OLC_SHOP(ch)   ((OLC_DATA(ch))->shop)        /* Shop structure.      */
#define OLC_DESC(ch)   ((OLC_DATA(ch))->desc)        /* Extra description.   */

/*
 * Other macros.
 */
#define OLC_EXIT(ch)   (OLC_ROOM(ch)->dir_option[OLC_VAL(ch)])
#define OLC_TRIG(ch)     ((OLC_DATA(ch))->trig)        /* Trigger structure.   */
#define OLC_STORAGE(ch)  ((OLC_DATA(ch))->storage)    /* For command storage  */

/*
 * Cleanup types.
 */
#define CLEANUP_ALL	      (byte)  1       /* Free the whole lot.  */
#define CLEANUP_STRUCTS       (byte)  2       /* Don't free strings.  */

/*
 * Submodes of OEDIT connectedness.
 */
#define OEDIT_MAIN_MENU 	      1
#define REDIT_MAIN_MENU 	      1
#define ZEDIT_MAIN_MENU 	      0
#define MEDIT_MAIN_MENU 	      0
#define SEDIT_MAIN_MENU 	      0
#define TRIGEDIT_MAIN_MENU 	      0

#define OEDIT_EDIT_NAMELIST	      2
#define OEDIT_SHORTDESC 	      3
#define OEDIT_LONGDESC  	      4
#define OEDIT_ACTDESC		      5
#define OEDIT_TYPE		      6
#define OEDIT_EXTRAS		      7
#define OEDIT_WEAR		      8
#define OEDIT_WEIGHT		      9
#define OEDIT_COST		      10
#define OEDIT_COSTPERDAY	      11
#define OEDIT_TIMER		      12
#define OEDIT_VALUE_1		      13
#define OEDIT_VALUE_2		      14
#define OEDIT_VALUE_3		      15
#define OEDIT_VALUE_4		      16
#define OEDIT_VALUE_5		      17
#define OEDIT_VALUE_6		      18
#define OEDIT_VALUE_7		      19
#define OEDIT_VALUE_8		      20
#define OEDIT_APPLY		      21
#define OEDIT_APPLYMOD  	      22
#define OEDIT_EXTRADESC_KEY	      23
#define OEDIT_CONFIRM_SAVEDB	      24
#define OEDIT_CONFIRM_SAVESTRING      25
#define OEDIT_PROMPT_APPLY	      26
#define OEDIT_EXTRADESC_DESCRIPTION   27
#define OEDIT_EXTRADESC_MENU	      28
#define OEDIT_LEVEL		      29
#define OEDIT_MATERIAL		      30
#define OEDIT_PD		      31
#define OEDIT_DR		      32
#define OEDIT_MAXHIT		      33
#define OEDIT_HIT		      34
#define OEDIT_MAXMANA		      35
#define OEDIT_MANA		      36
#define OEDIT_VALUE_MENU	      37
#define OEDIT_SPECPROC_MENU	      38

/*
 * Submodes of REDIT connectedness.
 */
#define REDIT_NAME		      2
#define REDIT_DESC		      3
#define REDIT_FLAGS		      4
#define REDIT_SECTOR		      5
#define REDIT_EXIT_MENU 	      6
#define REDIT_CONFIRM_SAVEDB	      7
#define REDIT_CONFIRM_SAVESTRING      8
#define REDIT_EXIT_NUMBER	      9
#define REDIT_EXIT_DESCRIPTION	      10
#define REDIT_EXIT_KEYWORD	      11
#define REDIT_EXIT_KEY  	      12
#define REDIT_EXIT_DOORFLAGS	      13
#define REDIT_EXTRADESC_MENU	      14
#define REDIT_EXTRADESC_KEY	      15
#define REDIT_EXTRADESC_DESCRIPTION   16
#define REDIT_COORDX		      17
#define REDIT_COORDY		      18
#define REDIT_SPECPROC_MENU	      19

/*
 * Submodes of ZEDIT connectedness.
 */
#define ZEDIT_DELETE_ENTRY	      1
#define ZEDIT_NEW_ENTRY 	      2
#define ZEDIT_CHANGE_ENTRY	      3
#define ZEDIT_COMMAND_TYPE	      4
#define ZEDIT_IF_FLAG		      5
#define ZEDIT_ARG1		      6
#define ZEDIT_ARG2		      7
#define ZEDIT_ARG3		      8
#define ZEDIT_ZONE_NAME 	      9
#define ZEDIT_ZONE_LIFE 	      10
#define ZEDIT_ZONE_TOP  	      11
#define ZEDIT_ZONE_RESET	      12
#define ZEDIT_CONFIRM_SAVESTRING      13

/*
 * Submodes of MEDIT connectedness.
 */
#define MEDIT_ALIAS		      1
#define MEDIT_S_DESC		      2
#define MEDIT_L_DESC		      3
#define MEDIT_D_DESC		      4
#define MEDIT_NPC_FLAGS 	      5
#define MEDIT_AFF_FLAGS 	      6
#define MEDIT_CONFIRM_SAVESTRING      7
#define MEDIT_SKILLS	 	      8
#define MEDIT_EXTENDED		      9
#define MEDIT_SPECPROC_MENU	      10
/*
 * Numerical responses.
 */
#define MEDIT_NUMERICAL_RESPONSE      10
#define MEDIT_SEX		      11
#define MEDIT_HITROLL		      12
#define MEDIT_DAMROLL		      13
#define MEDIT_MAX_RIDERS	      14
#define MEDIT_DISPOSITION	      15
// #define MEDIT_NDD		      14
// #define MEDIT_SDD		      15
#define MEDIT_NUM_HP_DICE	      16
#define MEDIT_SIZE_HP_DICE	      17
#define MEDIT_ADD_HP		      18
#define MEDIT_AC		      19
#define MEDIT_EXP		      20
#define MEDIT_GOLD		      21
#define MEDIT_POS		      22
#define MEDIT_DEFAULT_POS	      23
#define MEDIT_ATTACK		      24
#define MEDIT_LEVEL		      25
#define MEDIT_ALIGNMENT 	      26
#define MEDIT_SKILLPTS	 	      27
#define MEDIT_RACE		      28
#define MEDIT_CLASS		      29
#define MEDIT_STR		      30
#define MEDIT_INT		      31
#define MEDIT_WIS		      32
#define MEDIT_DEX		      33
#define MEDIT_CON		      34
#define MEDIT_CHA		      35
#define MEDIT_TOTALPTS		      36
#define MEDIT_MOBTYPE		      37
#define MEDIT_BODYTYPE		      38

/*
 * Submodes of SEDIT connectedness.
 */
#define SEDIT_CONFIRM_SAVESTRING      1
#define SEDIT_NOITEM1		      2
#define SEDIT_NOITEM2		      3
#define SEDIT_NOCASH1		      4
#define SEDIT_NOCASH2		      5
#define SEDIT_NOBUY		      6
#define SEDIT_BUY		      7
#define SEDIT_SELL		      8
#define SEDIT_PRODUCTS_MENU	      11
#define SEDIT_ROOMS_MENU	      12
#define SEDIT_NAMELIST_MENU	      13
#define SEDIT_NAMELIST  	      14
/*
 * Numerical responses.
 */
#define SEDIT_NUMERICAL_RESPONSE      20
#define SEDIT_OPEN1		      21
#define SEDIT_OPEN2		      22
#define SEDIT_CLOSE1		      23
#define SEDIT_CLOSE2		      24
#define SEDIT_KEEPER		      25
#define SEDIT_BUY_PROFIT	      26
#define SEDIT_SELL_PROFIT	      27
#define SEDIT_TYPE_MENU 	      29
#define SEDIT_DELETE_TYPE	      30
#define SEDIT_DELETE_PRODUCT	      31
#define SEDIT_NEW_PRODUCT	      32
#define SEDIT_DELETE_ROOM	      33
#define SEDIT_NEW_ROOM  	      34
#define SEDIT_SHOP_FLAGS	      35
#define SEDIT_NOTRADE		      36

#define SEDIT_PRAC_NOT_KNOWN	      37
#define SEDIT_PRAC_MISSING_CASH	      38

/*
 * Limit information.
 */
#define MAX_ROOM_NAME 75
#define MAX_MOB_NAME  50
#define MAX_OBJ_NAME  50
#define MAX_ROOM_DESC 1024
#define MAX_EXIT_DESC 256
#define MAX_MOB_DESC  512
#define MAX_OBJ_DESC  512

/* Daniel Houghton's OLC_SAVE states */
#define OLC_SAVE_NO		0
#define OLC_SAVE_YES		1
#define OLC_SAVE_COPY  		2
#define OLC_SAVE_OVERWRITE	3

/* Below defines are from DeathGate OLC, kept here for compatibility. */

/* OLC modes */
#define OLC_MEDIT      1
#define OLC_OEDIT      2
#define OLC_REDIT      3
#define OLC_ZEDIT      4
#define OLC_SEDIT      5
#define OLC_TRIGEDIT   6


/* Edit type (data type) */
#define EDT_LONG	0
#define EDT_INT		1
#define EDT_SHINT	2
#define EDT_BYTE	3
#define EDT_SBYTE	4
#define EDT_UBYTE	5

/* Edit Where */
#define EDW_BASE	0	/* base object (char_data, obj_data, etc) */
#define EDW_CDPLAYER	1	/* struct char_player_data		  */
#define EDW_CDPOINT	2	/* struct char_point_data		  */
#define EDW_CDCHSPEC	3	/* struct char_special_data               */
#define EDW_ODFLAG	4	/* struct obj_flag_data			  */
#define EDW_CDMOBSPEC   5       /* struct mob_special_data                */
#define EDW_CDCHABIL	6	/* struct char_abil_data		  */

/* Edit What */
#define EDK_INTEGER	0	/* integer value   */
#define EDK_BITVECT	1	/* bitvector       */
#define EDK_VALUE	2	/* value from list */
#define EDK_STRING	3	/* char *          */
#define EDK_SSTRING	4	/* sstring         */
#define EDK_DOORSTRING	5	/* door string     */
#define EDK_OBJVAL	6	/* door string     */
#define EDK_SPELLVALUE	7	/* Special value with checks for null spell */
#define EDK_DIFFVALUE	8	/* Special value which subtracts the beginning number  */


/* some max string lengths */
#define MAX_ROOM_NAME	75
#define MAX_MOB_NAME	50
#define MAX_OBJ_NAME	50
#define MAX_ZONE_NAME		50
#define MAX_ROOM_DESC	1024
#define MAX_MOB_DESC	512
#define MAX_OBJ_DESC	512
#define MAX_MOB_SHORT		50
#define MAX_OBJ_SHORT		50
#define MAX_MOB_LONG		79
#define MAX_DOORNAME_LENGTH	50
#define MAX_DOORDESC_LENGTH	512
#define MAX_EXDESC_LENGTH	512
#define MAX_FARG_LENGTH		512


#define OLCCMD(name)   void (name)(struct char_data *ch, int subcmd, \
				   char *argument)


extern void *get_olc_ptr(int target, int mode);
extern void *get_current_olc_ptr(char_data *ch, int target, int mode);
extern int check_olc_permission(struct char_data *ch, int targ, int mode);

extern int olc_interpreter(struct char_data *ch, char *argument);

extern void olc_show_obj(struct char_data *ch, void *ptr);
extern int oasis_gen_edit(struct char_data *ch, char *command, int menu, char *argument);

/* modes for do_stat_x for olc_show */
#define STAT_STAT	0
#define STAT_OLC	1

extern void do_stat_room(struct char_data * ch, struct room_data *rm, int mode);
extern void do_stat_object(struct char_data * ch, struct obj_data *j, int mode);
extern void do_stat_character(struct char_data * ch, struct char_data * k, int mode);

extern void insert_obj_proto(obj_data *obj);

/* Below are the DeathGate Oasis defines.  
**
** dg_olc.h: this header file is used in extending Oasis style OLC for
** dg-scripts onto a CircleMUD that already has dg-scripts (as released
** by Mark Heilpern on 1/1/98) implemented.
*/
/* #include "dg_scripts.h" */


/* prototype exported functions from dg_olc.c */
void script_copy(void *dst, void *src, int type);
void dg_olc_script_free(char_data *ch);
void dg_olc_script_copy(char_data *ch);
void dg_script_menu(char_data *ch);
int dg_script_edit_parse(char_data *ch, char *arg);

// exported from db.scripts.c
extern void free_int_list(struct int_list *list);
extern int_list * script_to_int_list (const script_data *from);


/* define the largest set of commands for as trigger */
#define MAX_CMD_LENGTH 16384 /* 16k should be plenty and then some */



#define NUM_TRIG_TYPE_FLAGS		13


/*
 * Submodes of TRIGEDIT connectedness.
 */
#define TRIGEDIT_MAIN_MENU              0
#define TRIGEDIT_TRIGTYPE               1
#define TRIGEDIT_CONFIRM_SAVESTRING	2
#define TRIGEDIT_NAME			3
#define TRIGEDIT_COMMANDS		4
#define TRIGEDIT_NARG			5
#define TRIGEDIT_ARGUMENT		6
#define TRIGEDIT_MOB_TYPES		7
#define TRIGEDIT_OBJ_TYPES		8
#define TRIGEDIT_WLD_TYPES		9
#define TRIGEDIT_NARG_BITV		10



#define OLC_SCRIPT_EDIT		     1000
#define SCRIPT_MAIN_MENU		1000
#define SCRIPT_NEW_TRIGGER		1001
#define SCRIPT_DEL_TRIGGER		1002


#define OLC_SCRIPT_EDIT_MODE(ch) (OLC_DATA(ch)->script_mode)	/* parse input mode */
#define OLC_SCRIPT(ch)           (OLC_DATA(ch)->script)	/* script editing   */
#define OLC_ITEM_TYPE(ch)	 (OLC_DATA(ch)->item_type)	/* mob/obj/room     */
 
