/************************************************************************
 *  OasisOLC - redit.c						v1.5	*
 *  Copyright 1996 Harvey Gilpin.					*
 *  Original author: Levork						*
 ************************************************************************/

#include "conf.h"
#include "sysdep.h"

#include "structs.h"
#include "scripts.h"
#include "index.h"
#include "comm.h"
#include "spells.h"
#include "utils.h"
#include "db.h"
#include "boards.h"
#include "olc.h"
#include "constants.h"
#include "events.h"
#include "editor.h"

#include "maputils.h"
#include "spec.h"

/* List each room saved, was used for debugging. */
#if 0
#define REDIT_LIST	1
#endif

/*------------------------------------------------------------------------*/

/*
 * External data structures.
 */
// extern int top_of_world;
// extern struct room_data *world;
// extern struct obj_data *obj_proto;
// extern struct char_data *mob_proto;
// extern char *room_bits[];
// extern char *sector_types[];
// extern char *exit_bits[];
// extern struct zone_data *zone_table;
// extern sh_int r_mortal_start_room;
// extern sh_int r_immort_start_room;
// extern sh_int r_frozen_start_room;
// extern sh_int mortal_start_room;
// extern sh_int immort_start_room;
// extern sh_int frozen_start_room;
// extern int top_of_zone_table;
// extern descriptor_data *descriptor_list;

extern int mapnums[MAP_ROWS][MAP_COLS];

/*------------------------------------------------------------------------*/

extern void edit_extradesc(char_data *ch, struct extra_descr_data *ed);
extern void   half_chop(char *string, char *arg1, char *arg2);
/*
 * Function Prototypes
 */
void redit_disp_extradesc_menu(char_data *ch);
void redit_disp_exit_menu(char_data *ch);
// void redit_disp_exit_flag_menu(char_data *ch);
// void redit_disp_flag_menu(char_data *ch);
void redit_disp_sector_menu(char_data *ch);
void redit_disp_menu(char_data *ch);
void redit_parse(char_data *ch, char *arg);
void redit_setup_new(char_data *ch);
void redit_setup_existing(char_data *ch, int real_num);
void redit_save_to_disk(int zone);
void redit_save_internally(char_data *ch);
void free_room(struct room_data *room);

extern void olc_disp_specproc_menu(char_data *ch);
extern void olc_edit_special(char_data *ch, char *argument);
extern void olc_display_bitvector(char_data *ch, const char **values, long &mask, sh_int &i);
extern int olc_edit_bitvector(struct char_data *ch, long *result, char *argument,
		       long old_bv, char *name, const char **values, long mask);
extern void erase_exdesc(struct extra_descr_data **head, struct extra_descr_data **target);


/*------------------------------------------------------------------------*/

#define  W_EXIT(room, num) (world[(room)].dir_option[(num)])

/*------------------------------------------------------------------------*\
  Utils and exported functions.
\*------------------------------------------------------------------------*/

void redit_setup_new(char_data *ch, int copyfrom)
{
  extern void init_room(room_data *room);
  OLC_ROOM(ch) = new room_data;

  if (!copyfrom) {
    init_room(OLC_ROOM(ch));
    OLC_SAVE(ch) = OLC_SAVE_NO;
  } else {
    if (world[copyfrom]->name)
      OLC_ROOM(ch)->name = str_dup (world[copyfrom]->name);
    if (world[copyfrom]->description)
      OLC_ROOM(ch)->description = str_dup (world[copyfrom]->description);
    if (world[copyfrom]->room_flags)
      OLC_ROOM(ch)->room_flags = world[copyfrom]->room_flags;
    if (world[copyfrom]->sector_type)
      OLC_ROOM(ch)->sector_type = world[copyfrom]->sector_type;

    if (SCRIPT(world[copyfrom]))
      OLC_SCRIPT(ch) = new script_data(SCRIPT(world[copyfrom]));
    else
      OLC_SCRIPT(ch) = new script_data;

    OLC_SAVE(ch) = OLC_SAVE_COPY;
  }
  redit_disp_menu(ch);
}
/*------------------------------------------------------------------------*/

void redit_setup_existing(char_data *ch, int copyfrom)
{   
  OLC_ROOM(ch) = new room_data;
  sh_int descsource,		// Identifies source of room descriptions.
         counter;

  if (!copyfrom) {
    descsource = OLC_NUM(ch);
    OLC_SAVE(ch) = OLC_SAVE_NO;
  } else {
    descsource = copyfrom;
    OLC_SAVE(ch) = OLC_SAVE_OVERWRITE;
  }
    
  if (world[descsource]->name)
    OLC_ROOM(ch)->name = str_dup (world[descsource]->name);
  if (world[descsource]->description)
    OLC_ROOM(ch)->description = str_dup (world[descsource]->description);
  if (world[descsource]->room_flags)
    OLC_ROOM(ch)->room_flags = world[descsource]->room_flags;
  if (world[descsource]->sector_type)
    OLC_ROOM(ch)->sector_type = world[descsource]->sector_type;

  /*. Extra descriptions if necessary .*/ 
  if (world[descsource]->ex_description) { 
    struct extra_descr_data *thisdesc, *temp, *temp2;

    CREATE (temp, struct extra_descr_data, 1);
    OLC_ROOM(ch)->ex_description = temp;
    for (thisdesc = world[descsource]->ex_description; thisdesc; thisdesc = thisdesc->next)
    { if (thisdesc->keyword)
        temp->keyword = ss_create(ss_data(thisdesc->keyword));
      if (thisdesc->description)
        temp->description = ss_create(ss_data(thisdesc->description));
      if (thisdesc->next)
      { CREATE (temp2, struct extra_descr_data, 1);
	temp->next = temp2;
	temp = temp2;
      } else
        temp->next = NULL;
    }
  }

  /* exits - alloc only if necessary */
  for (counter = 0; counter < NUM_OF_DIRS; counter++) { 
    if (world[OLC_NUM(ch)]->dir_option[counter]) { 
      CREATE(OLC_ROOM(ch)->dir_option[counter], struct room_direction_data, 1);
      /* copy numbers over */
      *OLC_ROOM(ch)->dir_option[counter] = *world[OLC_NUM(ch)]->dir_option[counter];
      /* malloc strings */
      if (world[OLC_NUM(ch)]->dir_option[counter]->general_description)
        OLC_ROOM(ch)->dir_option[counter]->general_description =
          str_dup(world[OLC_NUM(ch)]->dir_option[counter]->general_description);
      if (world[OLC_NUM(ch)]->dir_option[counter]->keyword)
        OLC_ROOM(ch)->dir_option[counter]->keyword =
          str_dup(world[OLC_NUM(ch)]->dir_option[counter]->keyword);
    }
  }
  
  if (SCRIPT(world[OLC_NUM(ch)]))
    OLC_SCRIPT(ch) = new script_data(SCRIPT(world[OLC_NUM(ch)]));
  else
    OLC_SCRIPT(ch) = new script_data;

  OLC_ROOM(ch)->coordx = world[OLC_NUM(ch)]->coordx;
  OLC_ROOM(ch)->coordy = world[OLC_NUM(ch)]->coordy;

  redit_disp_menu(ch);
}

/*------------------------------------------------------------------------*/

#define ZCMD (zone_table[zone].cmd[cmd_no])

void redit_save_internally(char_data *ch)
{
  sh_int room_num;

  room_num = real_room(OLC_NUM(ch));
  /*
   * Room exists: move contents over then free and replace it.
   */
  if (room_num != NOWHERE) {
    OLC_ROOM(ch)->contents = world[room_num]->contents;
    OLC_ROOM(ch)->people = world[room_num]->people;
#ifdef GOT_RID_OF_IT
    OLC_ROOM(ch)->script = world[room_num]->script;
    world[room_num]->script = NULL;
#endif
  }

  // Save map coordinates, if any.
  if (IS_SET(OLC_ROOM(ch)->room_flags, ROOM_MAP)) {
    mapnums[OLC_ROOM(ch)->coordy][OLC_ROOM(ch)->coordx] = OLC_NUM(ch);
  }

  insert_room(OLC_ROOM(ch), OLC_NUM(ch));
  OLC_ROOM(ch) = NULL;

  // Save the special procedures
  world[OLC_NUM(ch)]->func = OLC_DATA(ch)->func;
  if (world[OLC_NUM(ch)]->farg) {
    FREE(world[OLC_NUM(ch)]->farg);
  }
  world[OLC_NUM(ch)]->farg = OLC_DATA(ch)->farg;
  OLC_DATA(ch)->farg = NULL;

#ifdef GOT_RID_OF_IT
  FREE (SCRIPT(world[OLC_NUM(ch)]));
  SCRIPT(world[OLC_NUM(ch)]) = OLC_SCRIPT(ch);
  OLC_SCRIPT(ch) = NULL;
#endif

  if (SCRIPT(world[OLC_NUM(ch)])) {
    delete SCRIPT(world[OLC_NUM(ch)]);
    SCRIPT(world[OLC_NUM(ch)]) = NULL;
  }

  if (OLC_SCRIPT(ch)) {
    if (TRIGGERS(OLC_SCRIPT(ch))) {
      SCRIPT(world[OLC_NUM(ch)]) = OLC_SCRIPT(ch);
    } else {
      delete OLC_SCRIPT(ch);
    }
    OLC_SCRIPT(ch) = NULL;
  }

  olc_add_to_save_list(zone_table[OLC_ZNUM(ch)].number, OLC_REDIT);
}


/**************************************************************************
 Menu functions 
 **************************************************************************/

/*
 * For extra descriptions.
 */
void redit_disp_extradesc_menu(char_data *ch)
{
  struct extra_descr_data *extra_desc = OLC_DESC(ch);

  sprintf(buf,
#if defined(CLEAR_SCREEN)
	  "[H[J"
#endif
	  "&cG1&c0) Keyword: &cY%s\r\n"
	  "&cG2&c0) Description:\r\n&cY%s\r\n"
	  "&cG3&c0) Goto next description: %s\r\n"
	  "&cG4&c0) Erase this description\r\n",

	  extra_desc->keyword ? ss_data(extra_desc->keyword) : "<NONE>",
	  extra_desc->description ? ss_data(extra_desc->description) : "<NONE>",
	  !extra_desc->next ? "<Not set>" : "<Set>"
	  );

  strcat(buf, "Enter choice (0 to quit) : ");
  send_to_char(buf, ch);
  OLC_MENU(ch) = REDIT_EXTRADESC_MENU;
}

/*
 * For exits.
 */
void redit_disp_exit_menu(char_data *ch)
{
  /*
   * if exit doesn't exist, alloc/create it 
   */
  if (!OLC_EXIT(ch))
    CREATE(OLC_EXIT(ch), struct room_direction_data, 1);

  sprintbit(OLC_ROOM(ch)->dir_option[OLC_VAL(ch)]->exit_info, exit_bits, buf2);

  sprintf(buf,
#if defined(CLEAR_SCREEN)
	  "[H[J"
#endif
	  "&cG1&c0) Exit to     : &cC%d\r\n"
	  "&cG2&c0) Description :-\r\n&cY%s\r\n"
	  "&cG3&c0) Door name   : &cY%s\r\n"
	  "&cG4&c0) Key         : &cC%d\r\n"
	  "&cG5&c0) Door flags  : &cC%s\r\n"
	  "&cG6&c0) Purge exit.\r\n"
	  "Enter choice, 0 to quit : ",

	  OLC_EXIT(ch)->to_room != NOWHERE ? world[OLC_EXIT(ch)->to_room]->number : -1,
	  OLC_EXIT(ch)->general_description ? OLC_EXIT(ch)->general_description : "<NONE>",
	  OLC_EXIT(ch)->keyword ? OLC_EXIT(ch)->keyword : "<NONE>",
	  OLC_EXIT(ch)->key, buf2);

  send_to_char(buf, ch);
  OLC_MENU(ch) = REDIT_EXIT_MENU;
}

/*
 * For exit flags.
 */
void redit_disp_exit_flag_menu(char_data *ch)
{
  sh_int i;
  long mask = 0;
  olc_display_bitvector(ch, exit_bits, mask, i);
  sprintbit(OLC_ROOM(ch)->dir_option[OLC_VAL(ch)]->exit_info, exit_bits, buf1);
  send_to_charf(ch, "\r\nExit flags: &cC%s&c0\r\n"
	  "Enter exit flags, 0 to quit : ", buf1);
}

#ifdef GOT_RID_OF_IT
/*
 * For room flags.
 */
void redit_disp_flag_menu(char_data *ch)
{
  int counter, columns = 0;

#if defined(CLEAR_SCREEN)
  send_to_char("[H[J", ch);
#endif
#ifdef GOT_RID_OF_IT
  for (counter = 0; counter < NUM_ROOM_FLAGS; counter++) {
    sprintf(buf, "&cG%2d&c0) %-20.20s %s", counter + 1, 
		room_bits[counter], !(++columns % 2) ? "\r\n" : "");
    send_to_char(buf, ch);
  }
#endif
  oasis_gen_edit(ch, "", REDIT_FLAGS, "");
  sprintbit(OLC_ROOM(ch)->room_flags, room_bits, buf1);
  sprintf(buf, "\r\nRoom flags: &cC%s&c0\r\n"
	  "Enter room flags, 0 to quit : ", buf1);
  send_to_char(buf, ch);
}
#endif

/*
 * For sector type.
 */
void redit_disp_sector_menu(char_data *ch)
{
#ifdef GOT_RID_OF_IT
  int counter, columns = 0;

#if defined(CLEAR_SCREEN)
  send_to_char("[H[J", ch);
#endif
  for (counter = 0; counter < NUM_ROOM_SECTORS; counter++) {
    sprintf(buf, "&cG%2d&c0) %-20.20s %s", counter, 
		sector_types[counter], !(++columns % 2) ? "\r\n" : "");
    send_to_char(buf, ch);
  }
  send_to_char("\r\nEnter sector type : ", ch);
  OLC_MENU(ch) = REDIT_SECTOR;
#else
  OLC_MENU(ch) = REDIT_SECTOR;
  oasis_gen_edit(ch, "", REDIT_SECTOR, "");
  send_to_char("\r\nEnter sector type : ", ch);
#endif

}

/*
 * The main menu.
 */
void redit_disp_menu(char_data *ch)
{
  struct room_data *room;

  room = OLC_ROOM(ch);

  sprintbit((long)room->room_flags, room_bits, buf1);
  sprinttype(room->sector_type, sector_types, buf2);
  sprintf(buf,
#if defined(CLEAR_SCREEN)
	  "[H[J"
#endif
	  "-- Room number : [&cC%d&c0]  	Room zone: [&cC%d&c0]   %s %s\r\n"
	  "&cG1&c0) Name        : &cY%s\r\n"
	  "&cG2&c0) Description :\r\n&cY%s"
	  "&cG3&c0) Room flags  : &cC%s\r\n"
	  "&cG4&c0) Sector type : &cC%s\r\n"
	  "&cG5&c0) Exit north  : &cC%d\r\n"
	  "&cG6&c0) Exit east   : &cC%d\r\n"
	  "&cG7&c0) Exit south  : &cC%d\r\n"
	  "&cG8&c0) Exit west   : &cC%d\r\n"
	  "&cG9&c0) Exit up     : &cC%d\r\n"
	  "&cGA&c0) Exit down   : &cC%d\r\n"
	  "&cGB&c0) Extra descriptions menu\r\n"
	  "&cGP&c0) Special procedure : &cC%s\r\n"
          "&cGS&c0) Script attachments\r\n",

	  OLC_NUM(ch),
	  zone_table[OLC_ZNUM(ch)].number,
	  (OLC_SAVE(ch) == OLC_SAVE_COPY) ? "&cW&bb[ Copy ]&c0" : "",
	  (OLC_SAVE(ch) == OLC_SAVE_OVERWRITE) ? "&cW&br[ OVERWRITING ]&c0" : "",
	  room->name,
	  room->description,
	  buf1,
	  buf2,
	  room->dir_option[NORTH] && room->dir_option[NORTH]->to_room != -1 ?
	  world[room->dir_option[NORTH]->to_room]->number : -1,
	  room->dir_option[EAST] && room->dir_option[EAST]->to_room != -1 ?
	  world[room->dir_option[EAST]->to_room]->number : -1,
	  room->dir_option[SOUTH] && room->dir_option[SOUTH]->to_room != -1 ?
	  world[room->dir_option[SOUTH]->to_room]->number : -1,
	  room->dir_option[WEST] && room->dir_option[WEST]->to_room != -1 ?
	  world[room->dir_option[WEST]->to_room]->number : -1,
	  room->dir_option[UP] && room->dir_option[UP]->to_room != -1 ? 
	  world[room->dir_option[UP]->to_room]->number : -1,
	  room->dir_option[DOWN] && room->dir_option[DOWN]->to_room != -1 ?
	  world[room->dir_option[DOWN]->to_room]->number : -1,
	  (OLC_DATA(ch)->func == NULL) ? "None" : spec_room_name (OLC_DATA(ch)->func)
	  // CHANGEPOINT "Unsupported"
	  );

  if (IS_SET(room->room_flags, ROOM_MAP))
    sprintf(buf + strlen(buf), "&cGX&c0) X coord      : &cC%d\r\n" 
                               "&cGY&c0) Y coord      : &cC%d\r\n",
			       OLC_ROOM(ch)->coordx, OLC_ROOM(ch)->coordy);
	  
  strcat(buf, "&cGQ&c0) Quit\r\n" "Enter choice : ");

  send_to_char(buf, ch);

  OLC_MENU(ch) = REDIT_MAIN_MENU;
}

/**************************************************************************
  The main loop
 **************************************************************************/

void redit_parse(char_data *ch, char *arg)
{
  int number;
  struct finish_olcstr_data *std;
  struct finish_olcshr_data *shd;
  extern int olc_edit_bitvector(struct char_data *ch, long *result, char *argument,
		       long old_bv, char *name, const char **values, long mask);

  switch (OLC_MENU(ch)) {
  case REDIT_CONFIRM_SAVESTRING:
    switch (*arg) {
    case 'y':
    case 'Y':
      redit_save_internally(ch);
      sprintf(buf, "OLC: %s edits room %d.", GET_NAME(ch), OLC_NUM(ch));
      mudlog(buf, CMP, MAX(TRUST_CREATOR, GET_INVIS_LEV(ch)), TRUE);
      /*
       * Do NOT free strings! Just the room structure. 
       */
      cleanup_olc(ch, CLEANUP_STRUCTS);
      send_to_char("Room saved to memory.\r\n", ch);
      break;
    case 'n':
    case 'N':
      /*
       * Free everything up, including strings, etc.
       */
      cleanup_olc(ch, CLEANUP_ALL);
      break;
    default:
      send_to_char("Invalid choice!\r\nDo you wish to save this room internally? : ", ch);
      break;
    }
    return;

  case REDIT_MAIN_MENU:
    switch (*arg) {
    case 'q':
    case 'Q':
      if (OLC_SAVE(ch)) { /* Something has been modified. */
	send_to_char("Do you wish to save this room internally? : ", ch);
	OLC_MENU(ch) = REDIT_CONFIRM_SAVESTRING;
      } else
	cleanup_olc(ch, CLEANUP_ALL);
      return;
    case '1':
      send_to_char("Enter room name:-\r\n] ", ch);
      OLC_MENU(ch) = REDIT_NAME;
      break;
    case '2':
//      OLC_MENU(ch) = REDIT_DESC;
#if defined(CLEAR_SCREEN)
      send_to_char("\x1B[H\x1B[J", d);
#endif
#ifdef GOT_RID_OF_IT
      send_to_char("Enter room description: (/s saves /h for help)\r\n\r\n", ch);
      d->backstr = NULL;
      if (OLC_ROOM(ch)->description) {
	send_to_char(OLC_ROOM(ch)->description, d);
	d->backstr = str_dup(OLC_ROOM(ch)->description);
      }
      d->str = &OLC_ROOM(ch)->description;
      d->max_str = MAX_ROOM_DESC;
      d->mail_to = 0;
      OLC_SAVE(ch) = OLC_SAVE_YES;
#else
      send_to_char("Enter room description: (/s saves /h for help)\r\n\r\n", ch);
      oasis_gen_edit(ch, "", REDIT_DESC, "");
#endif
      if (!OLC_SAVE(ch))
        OLC_SAVE(ch) = OLC_SAVE_YES;
      break;
    case '3':
      OLC_MENU(ch) = REDIT_FLAGS;
      oasis_gen_edit(ch, "", REDIT_FLAGS, "");
      break;
    case '4':
      redit_disp_sector_menu(ch);
      break;
    case '5':
      OLC_VAL(ch) = NORTH;
      redit_disp_exit_menu(ch);
      break;
    case '6':
      OLC_VAL(ch) = EAST;
      redit_disp_exit_menu(ch);
      break;
    case '7':
      OLC_VAL(ch) = SOUTH;
      redit_disp_exit_menu(ch);
      break;
    case '8':
      OLC_VAL(ch) = WEST;
      redit_disp_exit_menu(ch);
      break;
    case '9':
      OLC_VAL(ch) = UP;
      redit_disp_exit_menu(ch);
      break;
    case 'a':
    case 'A':
      OLC_VAL(ch) = DOWN;
      redit_disp_exit_menu(ch);
      break;
    case 'b':
    case 'B':
      /*
       * If the extra description doesn't exist.
       */
      if (!OLC_ROOM(ch)->ex_description) {
	CREATE(OLC_ROOM(ch)->ex_description, struct extra_descr_data, 1);
	OLC_ROOM(ch)->ex_description->next = NULL;
      }
      OLC_DESC(ch) = OLC_ROOM(ch)->ex_description;
      redit_disp_extradesc_menu(ch);
      break;
    case 'p':
    case 'P':
      olc_disp_specproc_menu(ch);
      OLC_MENU(ch) = REDIT_SPECPROC_MENU;
      return;
    case 's':
    case 'S':
      dg_script_menu(ch);
      return;
    case 'x':
    case 'X':
      if (!IS_SET(OLC_ROOM(ch)->room_flags, ROOM_MAP)) {
        send_to_char("Invalid choice!\r\n", ch);
        redit_disp_menu(ch);
      } else {
        OLC_MENU(ch) = REDIT_COORDX;
	send_to_char("Enter X Coordinate: ", ch);
	break;
      }
      return;
    case 'y':
    case 'Y':
      if (!IS_SET(OLC_ROOM(ch)->room_flags, ROOM_MAP)) {
        send_to_char("Invalid choice!\r\n", ch);
        redit_disp_menu(ch);
      } else {
        OLC_MENU(ch) = REDIT_COORDY;
	send_to_char("Enter X Coordinate: ", ch);
	break;
      }
      return;
    default:
      send_to_char("Invalid choice!\r\n", ch);
      redit_disp_menu(ch);
      break;
    }
    return;

  case SCRIPT_MAIN_MENU:
  case SCRIPT_NEW_TRIGGER:
  case SCRIPT_DEL_TRIGGER:
    dg_script_edit_parse(ch, arg);
    return;
    break;

  case REDIT_NAME:
    if (OLC_ROOM(ch)->name)
      free(OLC_ROOM(ch)->name);
    if (strlen(arg) > MAX_ROOM_NAME)
      arg[MAX_ROOM_NAME - 1] = '\0';
    OLC_ROOM(ch)->name = str_dup((arg && *arg) ? arg : "undefined");
    break;

  case REDIT_DESC:
    /*
     * We will NEVER get here, we hope.
     */
    mudlog("SYSERR: Reached REDIT_DESC case in parse_redit", BRF, TRUST_CREATOR, TRUE);
    break;

  case REDIT_FLAGS:
    switch (*arg && (*arg != '0') && oasis_gen_edit(ch, "", REDIT_FLAGS, arg)) {
      case 0: redit_disp_menu(ch); return;
      default: 
        if (!OLC_SAVE(ch))
	  OLC_SAVE(ch) = OLC_SAVE_YES;
        oasis_gen_edit(ch, "", OLC_MENU(ch), ""); 
        return;
    }

#ifdef GOT_RID_OF_IT
    number = atoi(arg);
    if ((number < 0) || (number > NUM_ROOM_FLAGS)) {
      send_to_char("That is not a valid choice!\r\n", ch);
      redit_disp_flag_menu(ch);
    } else if (number == 0)
	break;
    else {
      /*
       * Toggle the bit.
       */
      TOGGLE_BIT(OLC_ROOM(ch)->room_flags, 1 << (number - 1));
      redit_disp_flag_menu(ch);
    }
#endif
    return;

  case REDIT_SECTOR:
    switch (*arg && (*arg != '0') && oasis_gen_edit(ch, "", REDIT_SECTOR, arg)) {
      default: 
        if (!OLC_SAVE(ch))
	  OLC_SAVE(ch) = OLC_SAVE_YES;
      case 0: redit_disp_menu(ch); return;
    }
#ifdef GOT_RID_OF_IT
    number = atoi(arg);
    if (number < 0 || number >= NUM_ROOM_SECTORS) {
      send_to_char("Invalid choice!\r\n", ch);
      redit_disp_sector_menu(ch);
      return;
    } else
      OLC_ROOM(ch)->sector_type = number;
    break;
#endif

  case REDIT_EXIT_MENU:
    switch (*arg) {
    case '0':
      break;
    case '1':
      OLC_MENU(ch) = REDIT_EXIT_NUMBER;
      send_to_char("Exit to room number : ", ch);
      return;
    case '2':
#ifdef GOT_RID_OF_IT
      OLC_MENU(ch) = REDIT_EXIT_DESCRIPTION;
      send_to_char("Enter exit description: (/s saves /h for help)\r\n\r\n", d);
      d->backstr = NULL;
      if (OLC_EXIT(ch)->general_description) {
	send_to_char(OLC_EXIT(ch)->general_description, d);
	d->backstr = str_dup(OLC_EXIT(ch)->general_description);
      }
      d->str = &OLC_EXIT(ch)->general_description;
      d->max_str = MAX_EXIT_DESC;
      d->mail_to = 0;
#else
      send_to_char("Enter exit description: (/s saves /h for help)\r\n\r\n", ch);
      oasis_gen_edit(ch, "", REDIT_EXIT_DESCRIPTION, "");
#endif
      return;
    case '3':
      OLC_MENU(ch) = REDIT_EXIT_KEYWORD;
      send_to_char("Enter keywords : ", ch);
      return;
    case '4':
      OLC_MENU(ch) = REDIT_EXIT_KEY;
      send_to_char("Enter key number : ", ch);
      return;
    case '5':
      OLC_MENU(ch) = REDIT_EXIT_DOORFLAGS;
      redit_disp_exit_flag_menu(ch);
      return;
    case '6':
      /*
       * Delete an exit.
       */
      if (OLC_EXIT(ch)->keyword)
	free(OLC_EXIT(ch)->keyword);
      if (OLC_EXIT(ch)->general_description)
	free(OLC_EXIT(ch)->general_description);
      if (OLC_EXIT(ch))
	free(OLC_EXIT(ch));
      OLC_EXIT(ch) = NULL;
      break;
    default:
      redit_disp_exit_menu(ch);
      return;
    }
    break;

  case REDIT_EXIT_NUMBER:
    if ((number = atoi(arg)) != -1)
      if ((number = real_room(number)) < 0) {
	send_to_char("That room does not exist, try again : ", ch);
	return;
      }
    OLC_EXIT(ch)->to_room = number;
    redit_disp_exit_menu(ch);
    return;

  case REDIT_EXIT_DESCRIPTION:
    /*
     * We should NEVER get here, hopefully.
     */
    mudlog("SYSERR: Reached REDIT_EXIT_DESC case in parse_redit", BRF, TRUST_CREATOR, TRUE);
    break;

  case REDIT_EXIT_KEYWORD:
    if (OLC_EXIT(ch)->keyword)
      free(OLC_EXIT(ch)->keyword);
    OLC_EXIT(ch)->keyword = ((arg && *arg) ? str_dup(arg) : 0);
    redit_disp_exit_menu(ch);
    return;

  case REDIT_EXIT_KEY:
    OLC_EXIT(ch)->key = atoi(arg);
    redit_disp_exit_menu(ch);
    return;

  case REDIT_EXIT_DOORFLAGS:
    switch (*arg && (*arg != '0') && 
            (olc_edit_bitvector(ch, &OLC_EXIT(ch)->exit_info,
                               arg, OLC_EXIT(ch)->exit_info, 
                               "Door flags", exit_bits, 0) == 2)) {
      case 0: redit_disp_menu(ch); return;
      default: 
        if (!OLC_SAVE(ch))
	  OLC_SAVE(ch) = OLC_SAVE_YES;
        redit_disp_exit_flag_menu(ch);
        return;
    }
    return;

  case REDIT_EXTRADESC_KEY:
    if (OLC_DESC(ch)->keyword)
      ss_free(OLC_DESC(ch)->keyword);
    OLC_DESC(ch)->keyword = (arg && *arg) ? ss_create(arg) : 0;

    redit_disp_extradesc_menu(ch);
    return;

  case REDIT_SPECPROC_MENU:
    if (*arg) {
      olc_edit_special(ch, arg);
      redit_disp_menu(ch);
      OLC_SAVE(ch) = OLC_SAVE_YES;
    } else {
      redit_disp_menu(ch);
    }
    return;

  case REDIT_EXTRADESC_MENU:
    if (!*arg) {
      redit_disp_extradesc_menu(ch);
      return;
    }
    switch ((number = atoi(arg))) {
    case 0:
      {
	/*
	 * If something got left out, delete the extra description
	 * when backing out to the menu.
	 */
	if (!OLC_DESC(ch)->keyword || !OLC_DESC(ch)->description) {
	  struct extra_descr_data **tmp_desc;

	  if (OLC_DESC(ch)->keyword)
	    free(OLC_DESC(ch)->keyword);
	  if (OLC_DESC(ch)->description)
	    free(OLC_DESC(ch)->description);

	  /*
	   * Clean up pointers.
	   */
	  for (tmp_desc = &(OLC_ROOM(ch)->ex_description); *tmp_desc;
	       tmp_desc = &((*tmp_desc)->next))
	    if (*tmp_desc == OLC_DESC(ch)) {
	      *tmp_desc = NULL;
	      break;
	    }
	  free(OLC_DESC(ch));
	}
      }
      break;
    case 1:
      OLC_MENU(ch) = REDIT_EXTRADESC_KEY;
      send_to_char("Enter keywords, separated by spaces : ", ch);
      return;
    case 2:
      // OLC_MENU(ch) = REDIT_EXTRADESC_DESCRIPTION;
#ifdef GOT_RID_OF_IT
      send_to_char("Enter extra description: (/s saves /h for help)\r\n\r\n", d);
      d->backstr = NULL;
      if (OLC_DESC(ch)->description) {
	send_to_char(OLC_DESC(ch)->description, d);
	d->backstr = str_dup(OLC_DESC(ch)->description);
      }
      d->str = &OLC_DESC(ch)->description;
      d->max_str = MAX_MESSAGE_LENGTH;
      d->mail_to = 0;;
#else
      send_to_char("Enter extra description: (/s saves /h for help)\r\n\r\n", ch);
      edit_extradesc(ch, OLC_DESC(ch));
#endif
      return;

    case 3:
      if (!OLC_DESC(ch)->keyword || !OLC_DESC(ch)->description) {
	send_to_char("You can't edit the next extra desc without completing this one.\r\n", ch);
	redit_disp_extradesc_menu(ch);
      } else {
	struct extra_descr_data *new_extra;

	if (OLC_DESC(ch)->next)
	  OLC_DESC(ch) = OLC_DESC(ch)->next;
	else {
	  /*
	   * Make new extra description and attach at end.
	   */
	  CREATE(new_extra, struct extra_descr_data, 1);
	  OLC_DESC(ch)->next = new_extra;
	  OLC_DESC(ch) = new_extra;
	}
	redit_disp_extradesc_menu(ch);
      }
      return;
    case 4:
      // Wipe out this description
      erase_exdesc(&OLC_ROOM(ch)->ex_description, &OLC_DESC(ch));
      redit_disp_menu(ch);
      return;
      /*
       * No break - drop into default case.
       */
    break;
    }

  case REDIT_COORDX:
    number = atoi(arg);
    number = MAX(MIN(number, 99), 0);
    OLC_ROOM(ch)->coordx = number;
    break;
  case REDIT_COORDY:
    number = atoi(arg);
    number = MAX(MIN(number, 99), 0);
    OLC_ROOM(ch)->coordy = number;
    break;

  default:
    /*
     * We should never get here.
     */
    mudlog("SYSERR: Reached default case in parse_redit", BRF, TRUST_CREATOR, TRUE);
    break;
  }
  /*
   * If we get this far, something has been changed.
   */
  OLC_SAVE(ch) = OLC_SAVE_YES;
  redit_disp_menu(ch);
}
