/**************************************************************************
*  File: scripts.h                                                        *
*  Usage: header file for script structures and contstants, and           *
*         function prototypes for scripts.c                               *
*                                                                         *
*                                                                         *
*  $Author: tlo $
*  $Date: 1999/03/06 18:27:08 $
*  $Revision: 6.6 $
**************************************************************************/

#define    MOB_TRIGGER   0
#define    OBJ_TRIGGER   1
#define    WLD_TRIGGER   2


/* mob trigger types */
#define MTRIG_GLOBAL           (1 << 0)      /* check even if zone empty   */
#define MTRIG_RANDOM           (1 << 1)      /* checked randomly           */
#define MTRIG_COMMAND          (1 << 2)	     /* character types a command  */
#define MTRIG_SPEECH           (1 << 3)	     /* a char says a word/phrase  */
#define MTRIG_ACT              (1 << 4)      /* word or phrase sent to act */
#define MTRIG_DEATH            (1 << 5)      /* character dies             */
#define MTRIG_GREET            (1 << 6)      /* something enters room seen */
#define MTRIG_GREET_ALL        (1 << 7)      /* anything enters room       */
#define MTRIG_ENTRY            (1 << 8)      /* the mob enters a room      */
#define MTRIG_RECEIVE          (1 << 9)      /* character is given obj     */
#define MTRIG_FIGHT            (1 << 10)     /* each pulse while fighting  */
#define MTRIG_HITPRCNT         (1 << 11)     /* fighting and below some hp */
#define MTRIG_BRIBE	       (1 << 12)     /* coins are given to mob     */
#define MTRIG_LOAD             (1 << 13)     /* the mob is loaded          */
#define MTRIG_MEMORY           (1 << 14)     /* mob see's someone remembered */

/* obj trigger types */
#define OTRIG_GLOBAL           (1 << 0)	     /* unused                     */
#define OTRIG_RANDOM           (1 << 1)	     /* checked randomly           */
#define OTRIG_COMMAND          (1 << 2)      /* character types a command  */

#define OTRIG_TIMER            (1 << 5)     /* item's timer expires       */
#define OTRIG_GET              (1 << 6)     /* item is picked up          */
#define OTRIG_DROP             (1 << 7)     /* character trys to drop obj */
#define OTRIG_GIVE             (1 << 8)     /* character trys to give obj */
#define OTRIG_WEAR             (1 << 9)     /* character trys to wear obj */
#define OTRIG_REMOVE           (1 << 11)    /* character trys to remove obj */

#define OTRIG_LOAD             (1 << 13)    /* the object is loaded       */

/* wld trigger types */
#define WTRIG_GLOBAL           (1 << 0)      /* check even if zone empty   */
#define WTRIG_RANDOM           (1 << 1)	     /* checked randomly           */
#define WTRIG_COMMAND          (1 << 2)	     /* character types a command  */
#define WTRIG_SPEECH           (1 << 3)      /* a char says word/phrase    */

#define WTRIG_RESET            (1 << 5)      /* zone has been reset        */
#define WTRIG_ENTER            (1 << 6)	     /* character enters room      */
#define WTRIG_DROP             (1 << 7)      /* something dropped in room  */


/* obj command trigger types */
#define OCMD_EQUIP             (1 << 0)	     /* obj must be in char's equip */
#define OCMD_INVEN             (1 << 1)	     /* obj must be in char's inven */
#define OCMD_ROOM              (1 << 2)	     /* obj must be in char's room  */

#define TRIG_NEW                0	     /* trigger starts from top  */
#define TRIG_RESTART            1	     /* trigger restarting       */

#define SCRIPTCMD(name)  \
    void (name)(game_data *thing, char *argument, int cmd, int subcmd, int room)

// do_scriptsend
#define SCMD_SEND        0
#define SCMD_ECHOAROUND  1

SCRIPTCMD(do_scriptecho);
SCRIPTCMD(do_scriptasound);
SCRIPTCMD(do_scriptzoneecho);
SCRIPTCMD(do_scriptforce);
SCRIPTCMD(do_scriptsend);
SCRIPTCMD(do_scriptexp);
SCRIPTCMD(do_scripttransform);
SCRIPTCMD(do_scriptpurge);
SCRIPTCMD(do_scriptteleport);
SCRIPTCMD(do_scriptload);
SCRIPTCMD(do_scriptdamage);
SCRIPTCMD(do_scriptskillset);
SCRIPTCMD(do_scriptsetchar);
SCRIPTCMD(do_scriptat);


// Variable namespaces
enum var_namespaces {
  SPACE_LOCAL,
  SPACE_GLOBAL,
  SPACE_SHARED
};


// Conditions and filters for the foreach loop
enum foreach_conditions {
  FOREACH_OBJS,
  FOREACH_MOBS,
  FOREACH_ROOMS,
  FOREACH_SAMEZONE,
  FOREACH_SAMEROOM,
  FOREACH_CONTENTS,
  FOREACH_GROUP,
  FOREACH_FIGHTING,
  FOREACH_RIDING
};


// This is a parameter to the script compiler telling it what tables to look in.
enum command_interpreter_tables {
  COMMAND_PC,
  COMMAND_WIZARD,
  COMMAND_GENCMD,
  COMMAND_GENSCRIPT,
  COMMAND_MOBSCRIPT,
  COMMAND_OBJSCRIPT,
  COMMAND_ROOMSCRIPT
};


// The interpreter checks for these variables to determine if a compiled version exists.
enum script_command_switches {
  SCRIPTC_NONE,
  SCRIPTC_COMMENT,
  SCRIPTC_IF,
  SCRIPTC_ELSEIF,
  SCRIPTC_ELSE,
  SCRIPTC_WHILE,
  SCRIPTC_FOREACH,
  SCRIPTC_SWITCH,
  SCRIPTC_END,
  SCRIPTC_DONE,
  SCRIPTC_BREAK,
  SCRIPTC_CASE,
  SCRIPTC_DEFAULT,
  SCRIPTC_CONTEXT,
  SCRIPTC_DELAY,
  SCRIPTC_EVAL,
  SCRIPTC_EVALGLOBAL,
  SCRIPTC_EVALSHARED,
  SCRIPTC_EXTRACT,
  SCRIPTC_GLOBAL,
  SCRIPTC_HALT,
  SCRIPTC_MAKEUID,
  SCRIPTC_REMOTE,
  SCRIPTC_RETURN,
  SCRIPTC_SET,
  SCRIPTC_SETGLOBAL,
  SCRIPTC_SETSHARED,
  SCRIPTC_SHARED,
  SCRIPTC_UNSET,
  SCRIPTC_WAIT,
  SCRIPTC_PUSHFRONT,
  SCRIPTC_POPFRONT,
  SCRIPTC_PUSHBACK,
  SCRIPTC_POPBACK,
  SCRIPTC_MOBCMD,
  SCRIPTC_OBJCMD,
  SCRIPTC_WLDCMD,
  SCRIPTC_SCRIPTCMD
};


/*
 * These are slightly off of PULSE_MOBILE so
 * everything isnt happening at the same time 
 */
#define PULSE_SCRIPT            (13 RL_SEC)


#define MAX_SCRIPT_DEPTH      10          /* maximum depth triggers can
					     recurse into each other */


struct obj_command_info {
   char *command;
   void (*command_pointer) (obj_data * obj, char *argument, int cmd, int subcmd);
   int	subcmd;
};


struct wld_command_info {
    char *command;
    void (*command_pointer)
    (room_data * room, char *argument, int cmd, int subcmd);
    int	subcmd;
};


struct script_command_info {
    char *command;
    void (*command_pointer)
    (game_data * thing, char *argument, int cmd, int subcmd, int room);
    int	subcmd;
};


extern const struct wld_command_info wld_cmd_info[];
extern const struct obj_command_info obj_cmd_info[];
extern const struct script_command_info script_cmd_info[];


/* one line of the trigger */
class cmdlist_element {
public:
  char *cmd;				/* one line of a trigger */
  struct cmdlist_element *original;
  struct cmdlist_element *next;
  unsigned long loopcount;		// Number of times this line has looped

  // void * function;			// Pointer to the function called
  sh_int type;				// Which command type?
  sh_int number;			// Which command number?
  // sh_int subcmd;
  
  cmdlist_element();
  cmdlist_element(const char * line);
  ~cmdlist_element();
};

/* shared string command struct */
typedef struct {
  struct cmdlist_element *command;
  int count;
} scommand;

extern scommand *scommand_create(char *str);
extern scommand *scommand_share(scommand *ss);
extern void scommand_free(scommand *ss);

#define scommand_data(ss)   ((ss) ? (ss)->command : (cmdlist_element *) NULL)

class trig_var_data {
public:
  trig_var_data(void);
  trig_var_data(const trig_var_data *trgvar);
  ~trig_var_data(void);

  char *name;				/* name of variable  */
  char *value;				/* value of variable */
  long context;				/* 0: global context */
  
  struct trig_var_data *next;

private:
    void init(void);
};

/* structure for triggers */
class trig_data : public all_data {
public:
    trig_data(void);
    trig_data(const trig_data *trg);
    ~trig_data(void);
    void copyover(const trig_data *trg);

    sh_int nr;		                /* trigger's rnum                  */
    byte data_type;		        /* type of game_data for trig      */
    // byte attach_type;		        /* type of game_data for trig      */
    ubyte purged;			/* trigger is set to be purged     */
    long trigger_type_mob;		/* type of trigger (for bitvector) */
    long trigger_type_obj;		/* type of trigger (for bitvector) */
    long trigger_type_wld;		/* type of trigger (for bitvector) */
    int narg;				/* numerical argument              */
    int depth;				/* depth into nest ifs/whiles/etc  */
    int loops;				/* depth into nest ifs/whiles/etc  */
    scommand *cmdlist;			/* top of command list             */
    struct cmdlist_element *curr_state;	/* ptr to current line of trigger  */
    sstring *name;		        /* name of trigger                 */
    sstring *arglist;			/* argument list                   */
    struct event *wait_event;	        /* event to pause the trigger      */
    struct event_list *delay_event;	/* event to pause the trigger      */
    struct trig_var_data *var_list;	/* list of local vars for trigger  */
    
    struct trig_data *next;  

private:
    void init(void);
};


/* a complete script (composed of several triggers) */
class script_data {
public:
  script_data(void);
  script_data(const script_data *from);
  script_data(struct int_list *from);
  void copyvars(const script_data *from);
  void copyintlist(const struct int_list *from);
  ~script_data(void);

#ifdef GOT_RID_OF_IT
  void AddTrigger(trig_data *t, int loc);
  void DelTrigger(char *name);
#endif

  long types;				/* bitvector of trigger types */
  struct trig_data *trig_list;		/* list of triggers           */
  struct trig_var_data *global_vars;	/* list of global variables   */
  long context;				/* current context for statics */
  struct memory_data *memory;		/* for memory triggers */
  byte attach_type;			// The type of object attached to
  ubyte purged;				/* script is set to be purged */

  struct script_data *next;		/* used for purged_scripts    */

private:
    void init(void);
};


/* used for actor memory triggers */
struct script_memory {
  long id;				/* id of who to remember */
  char *cmd;				/* command, or NULL for generic */
  struct script_memory *next;
};


/* function prototypes from triggers.c */
   /* mob triggers */
void random_mtrigger(struct char_data *ch);
void load_mtrigger(char_data *ch);

   /* object triggers */
void random_otrigger(struct obj_data *obj);
void load_otrigger(obj_data *obj);

   /* world triggers */
void random_wtrigger(struct room_data *ch);


/* function prototypes from scripts.c */
void script_trigger_check(void);
void add_trigger(struct script_data *sc, struct trig_data *t, int loc);

void do_stat_trigger(struct char_data *ch, struct trig_data *trig);
void do_sstat_room(struct char_data * ch);
void do_sstat_object(struct char_data * ch, struct obj_data * j);
void do_sstat_character(struct char_data * ch, struct char_data * k);

void script_log(char *msg);


/* Macros for scripts */

#define GET_TRIG_NAME(t)          (ss_data((t)->name))
#define GET_TRIG_RNUM(t)          ((t)->nr)
#define GET_TRIG_VNUM(t)	  ((t)->nr)
// #define GET_TRIG_ATTACH(t)        ((t)->attach_type)
// #define GET_TRIG_TYPE(t)          ((t)->trigger_type)
#define GET_TRIG_DATA_TYPE(t)	  ((t)->data_type)
#define GET_TRIG_NARG(t)          ((t)->narg)
#define GET_TRIG_ARG(t)           (ss_data((t)->arglist))
#define GET_TRIG_VARS(t)	  ((t)->var_list)
#define GET_TRIG_WAIT(t)	  ((t)->wait_event)
#define GET_TRIG_DELAYED(t)	  ((t)->delay_event)
#define GET_TRIG_DEPTH(t)         ((t)->depth)
#define GET_TRIG_LOOPS(t)         ((t)->loops)

#define GET_TRIG_TYPE_MOB(t)          ((t)->trigger_type_mob)
#define GET_TRIG_TYPE_OBJ(t)          ((t)->trigger_type_obj)
#define GET_TRIG_TYPE_WLD(t)          ((t)->trigger_type_wld)

#define SCRIPT(o)		  ((o)->script)
#define SCRIPT_MEM(c)             ((c)->memory)

#define SCRIPT_TYPES(s)		  ((s)->types)				  
#define TRIGGERS(s)		  ((s)->trig_list)


#define SCRIPT_CHECK(go, type)   (SCRIPT(go) && \
				  IS_SET(SCRIPT_TYPES(SCRIPT(go)), type))
#define TRIGGER_CHECK_MOB(t, type)   (IS_SET(GET_TRIG_TYPE_MOB(t), type) && \
				  !GET_TRIG_DEPTH(t))
#define TRIGGER_CHECK_OBJ(t, type)   (IS_SET(GET_TRIG_TYPE_OBJ(t), type) && \
				  !GET_TRIG_DEPTH(t))
#define TRIGGER_CHECK_WLD(t, type)   (IS_SET(GET_TRIG_TYPE_WLD(t), type) && \
				  !GET_TRIG_DEPTH(t))

#define ADD_UID_VAR(buf, trig, go, name, context) { \
			         sprintf(buf, "%c%ld", UID_CHAR, GET_ID(go)); \
                         add_var(&GET_TRIG_VARS(trig), name, buf, context); }
