/*
** dg_olc.c: this source file is used in extending Oasis style OLC for
** dg-scripts onto a CircleMUD that already has dg-scripts (as released
** by Mark Heilpern on 1/1/98) implemented.
**
** Parts of this file by Chris Jacobson of _Aliens vs Predator: The MUD_
*/


#include "conf.h"
#include "sysdep.h"

#include "structs.h"
#include "scripts.h"
#include "index.h"
#include "utils.h"
#include "comm.h"
#include "db.h"
#include "olc.h"
#include "constants.h"
#include "events.h"
#include "editor.h"

/* declare externally defined globals */
extern char *trig_types[], *otrig_types[], *wtrig_types[];
extern struct zone_data *zone_table;
extern const char *ocmd_place_vector[];

#define PROTO_TRIG(num) ((trig_data *) trig_index[(num)]->proto)

/* prototype externally defined functions */
void trig_data_copy(trig_data *from, const trig_data *trg);
void free_varlist(struct trig_var_data *vd);

void trigedit_disp_menu(char_data *ch);
void trigedit_save(char_data *ch);

extern void medit_disp_menu(char_data *ch);
extern void oedit_disp_menu(char_data *ch);
extern void redit_disp_menu(char_data *ch);
extern void sedit_disp_menu(char_data *ch);
extern void zedit_disp_menu(char_data *ch);
extern void trigedit_disp_menu(char_data *ch);
extern char *two_arguments(char *argument, char *first_arg, char *second_arg);
extern int remove_trigger(struct script_data *sc, char *name);


void trigedit_setup_new(char_data *ch, int copyfrom)
{
  cmdlist_element *c = NULL;
  
  if (!copyfrom) {
    OLC_TRIG(ch) = new trig_data;
    OLC_SAVE(ch) = OLC_SAVE_NO;

    OLC_TRIG(ch)->nr = OLC_NUM(ch);

  /*
   * Set up some defaults
   */ 
    OLC_TRIG(ch)->name = ss_create("new trigger");
    OLC_TRIG(ch)->trigger_type_mob = MTRIG_GREET;

    /* cmdlist will be a large char string until the trigger is saved */
    CREATE(OLC_STORAGE(ch), char, MAX_CMD_LENGTH);
    strcpy(OLC_STORAGE(ch),
    "say My trigger commandlist is not complete!\r\n");
    OLC_TRIG(ch)->narg = 100;
  } else {
    OLC_TRIG(ch) = new trig_data;
    OLC_TRIG(ch)->copyover(PROTO_TRIG(copyfrom));
    OLC_SAVE(ch) = OLC_SAVE_COPY;

    /* convert cmdlist to a char string */
    CREATE(OLC_STORAGE(ch), char, MAX_CMD_LENGTH);
    *OLC_STORAGE(ch) = '\0';

    c = PROTO_TRIG(copyfrom)->cmdlist->command;
    while (c) {
      strcat(OLC_STORAGE(ch), c->cmd);
      strcat(OLC_STORAGE(ch), "\r\n");
      c = c->next;
    }
  }

  GET_TRIG_RNUM(OLC_TRIG(ch)) = OLC_NUM(ch);
    
  trigedit_disp_menu(ch);
}

void trigedit_setup_existing(char_data *ch, int copyfrom)
{
  cmdlist_element *c;

  if (!copyfrom) {
    OLC_TRIG(ch) = new trig_data(PROTO_TRIG(OLC_NUM(ch)));
    OLC_SAVE(ch) = OLC_SAVE_NO;
    c = PROTO_TRIG(OLC_NUM(ch))->cmdlist->command;
  } else {
    OLC_TRIG(ch) = new trig_data;
    OLC_TRIG(ch)->copyover(PROTO_TRIG(copyfrom));
    OLC_SAVE(ch) = OLC_SAVE_OVERWRITE;
    c = PROTO_TRIG(copyfrom)->cmdlist->command;
  }

  GET_TRIG_RNUM(OLC_TRIG(ch)) = OLC_NUM(ch);

  /* convert cmdlist to a char string */
  CREATE(OLC_STORAGE(ch), char, MAX_CMD_LENGTH);
  strcpy(OLC_STORAGE(ch), "");
  
  while (c) {
    strcat(OLC_STORAGE(ch), c->cmd);
    strcat(OLC_STORAGE(ch), "\r\n");
    c = c->next;
  }
  /* now trig->cmdlist is something to pass to the text editor */
  /* it will be converted back to a real cmdlist_element list later */

  trigedit_disp_menu(ch);
}


void trigedit_disp_menu(char_data *ch)
{
  struct trig_data *trig = OLC_TRIG(ch);
  char trgtypes_mob[256], trgtypes_obj[256], trgtypes_wld[256];
  extern const char *trig_attach_types[];

  sprintbit (GET_TRIG_TYPE_MOB(trig), (const char **) trig_types, trgtypes_mob);
  sprintbit (GET_TRIG_TYPE_OBJ(trig), (const char **) otrig_types, trgtypes_obj);
  sprintbit (GET_TRIG_TYPE_WLD(trig), (const char **) wtrig_types, trgtypes_wld);

  sprintf(buf,
#if defined(CLEAR_SCREEN)
"[H[J"
#endif

  "Trigger Editor [&cC%d&c0]   %s %s\r\n"
  "&cG1&c0) Name                 : &cY%s\r\n"
  "&cG2&c0) Mobile trigger types : &cY%s\r\n"
  "&cG3&c0) Object trigger types : &cY%s\r\n"
  "&cG4&c0) Room trigger types   : &cY%s\r\n"
  "&cG5&c0) Numeric Arg          : &cY%d\r\n"
  "&cG6&c0) Arguments            : &cY%s\r\n"
  "&cG7&c0) Commands:\r\n&cC%s\r\n"
  "&cGQ&c0) Quit\r\n"
  "Enter Choice :",

  OLC_NUM(ch),			// vnum on the title line 
  (OLC_SAVE(ch) == OLC_SAVE_COPY) ? "&cW&bb[ Copy ]&c0" : "",
  (OLC_SAVE(ch) == OLC_SAVE_OVERWRITE) ? "&cW&br[ OVERWRITING ]&c0" : "",
  GET_TRIG_NAME(trig),		// name                   
  trgtypes_mob,			// greet/drop/etc         
  trgtypes_obj,			// greet/drop/etc         
  trgtypes_wld,			// greet/drop/etc         
  GET_TRIG_NARG(trig),				// numeric arg
  GET_TRIG_ARG(trig),				// strict arg
  OLC_STORAGE(ch)		// the command list          
  );

  send_to_char(buf, ch);
  OLC_MENU(ch) = TRIGEDIT_MAIN_MENU;
}


void edit_script_commands (char_data *ch)
{
  struct finish_olcstr_data *std;
  extern int olc_edit_string(struct char_data *ch, char **string, char *argument,
		    char *name, EDITFUNC(*func), void *ed_data, int size,
		    int append);

  CREATE(std, struct finish_olcstr_data, 1);
  std->string = &OLC_STORAGE(ch);
  std->mode = GET_OLC_MODE(ch);
  std->target = OLC_NUM(ch);
  std->ptr = OLC_TRIG(ch);

  olc_edit_string(ch, std->string, "", "commands",
        	  finish_olc_string, std, MAX_CMD_LENGTH, EDIT_APPEND);
  return;
}


void trigedit_parse(char_data * ch, char *arg)
{
  int i = 0;

  switch (OLC_MENU(ch)) {
  case TRIGEDIT_MAIN_MENU:
    switch (tolower(*arg)) {
    case 'q':
      if (OLC_SAVE(ch)) {	/* Anything been changed? */
	send_to_char("Do you wish to save the changes to the trigger? (y/n): ", ch);
	OLC_MENU(ch) = TRIGEDIT_CONFIRM_SAVESTRING;
      }
      else
	cleanup_olc(ch, CLEANUP_ALL);
      return;
    case '1':
      OLC_MENU(ch) = TRIGEDIT_NAME;
      send_to_char("Name: ", ch);
      break;
    case '2':
      OLC_MENU(ch) = TRIGEDIT_MOB_TYPES;
      oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      break;
    case '3':
      OLC_MENU(ch) = TRIGEDIT_OBJ_TYPES;
      oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      break;
    case '4':
      OLC_MENU(ch) = TRIGEDIT_WLD_TYPES;
      oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      break;
    case '5':
      if (TRIGGER_CHECK_OBJ(OLC_TRIG(ch), OTRIG_COMMAND)) {
	OLC_MENU(ch) = TRIGEDIT_NARG_BITV;
	oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      } else {
	OLC_MENU(ch) = TRIGEDIT_NARG;
	send_to_char("Numeric argument: ", ch);
      }
      break;
    case '6':
      OLC_MENU(ch) = TRIGEDIT_ARGUMENT;
      send_to_char("Argument: ", ch);
      break;
    case '7':
      if (!OLC_SAVE(ch))
	OLC_SAVE(ch) = OLC_SAVE_YES;
      edit_script_commands(ch);
      break;
    default:
      trigedit_disp_menu(ch);
      return;
    }
    return;

  case TRIGEDIT_CONFIRM_SAVESTRING:
    switch (tolower(*arg)) {
    case 'y':
      trigedit_save(ch);
      sprintf(buf, "OLC: %s edits trigger %d", GET_NAME(ch),
	      OLC_NUM(ch));
      mudlog(buf, CMP, MAX(TRUST_CREATOR, GET_INVIS_LEV(ch)), TRUE);
      /* fall through */
    case 'n':
      cleanup_olc(ch, CLEANUP_ALL);
      return;
    case 'a':			/* abort quitting */
      break;
    default:
      send_to_char("Invalid choice!\r\n", ch);
      send_to_char("Do you wish to save the trigger? : ", ch);
      return;
    }
    break;

  case TRIGEDIT_NAME:
  case TRIGEDIT_NARG:
    if (*arg && oasis_gen_edit(ch, "", OLC_MENU(ch), arg)) {
      if (!OLC_SAVE(ch))
	OLC_SAVE(ch) = OLC_SAVE_YES;
    }
    break;

  case TRIGEDIT_NARG_BITV:
    switch (*arg && oasis_gen_edit(ch, "", OLC_MENU(ch), arg)) {
    case 0:
      trigedit_disp_menu(ch);
      return;
    default:
      if (!OLC_SAVE(ch))
	OLC_SAVE(ch) = OLC_SAVE_YES;
      oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      return;
    }
    break;

  case TRIGEDIT_ARGUMENT:
    if (OLC_TRIG(ch)->arglist)
      ss_free(OLC_TRIG(ch)->arglist);
    OLC_TRIG(ch)->arglist = (arg && *arg) ? ss_create(arg) : 0;
    break;

  case TRIGEDIT_MOB_TYPES:
  case TRIGEDIT_OBJ_TYPES:
  case TRIGEDIT_WLD_TYPES:
    switch (*arg && oasis_gen_edit(ch, "", OLC_MENU(ch), arg)) {
    case 0:
      trigedit_disp_menu(ch);
      return;
    default:
      if (!OLC_SAVE(ch))
	OLC_SAVE(ch) = OLC_SAVE_YES;
      oasis_gen_edit(ch, "", OLC_MENU(ch), "");
      return;
    }
    return;

  case TRIGEDIT_COMMANDS:
    break;

  }

  /*
   * If we get here, we have changed something.  
   */
  if (!OLC_SAVE(ch))
    OLC_SAVE(ch) = OLC_SAVE_YES;
  trigedit_disp_menu(ch);
}

/*
** print out the letter codes pertaining to the bits set in 'data'
*/
void sprintbits(int data, char *dest)
{
  int i;
  char *p = dest;

  for (i=0; i<32; i++) {
    if (data & (1<<i)) {
      *p = ((i<=25)?('a'+i):('A'+i));
      p++;
    }
  }
  *p = '\0';
}


/* save the zone's triggers to internal memory and to disk */
void trigedit_save(char_data *ch)
{
  extern void insert_trig_proto(trig_data *trig);
  char *s = OLC_STORAGE(ch);
  cmdlist_element *cmd, *cmd_next;
  trig_data *trig = OLC_TRIG(ch);

  // Now write the stored script commands to memory.

  if (trig->cmdlist)
    scommand_free(trig->cmdlist);

  trig->cmdlist = scommand_create(strtok (s, "\n\r"));
  cmd = trig->cmdlist->command;

  while ((s = strtok(NULL, "\n\r"))) {
    cmd->next = new cmdlist_element(s);
    cmd = cmd->next;
    // CREATE(cmd->next, struct cmdlist_element, 1);
    // cmd->next->cmd = str_dup(s);
    // if (cmd->next->cmd)
    //   cmd = cmd->next;
    // else {
    //   FREE(cmd->next);
    //   cmd->next = NULL;
    //   break;
    // }
  }

  /* write to internal tables */
  if (trig_index[OLC_NUM(ch)] > 0) {

    // This code is supposed to be in the trig_data destructor, but something
    // is screwy and I'll put it here, where it's most needed, until I find
    // out what's up.
    scommand_free(PROTO_TRIG(OLC_NUM(ch))->cmdlist);

    // Let's preserve the shared variables...
    OLC_TRIG(ch)->var_list = PROTO_TRIG(OLC_NUM(ch))->var_list;
    PROTO_TRIG(OLC_NUM(ch))->var_list = NULL;

    /* now safe to free old proto and write over */
    FREE (trig_index[OLC_NUM(ch)]->proto);
    trig_index[OLC_NUM(ch)]->proto = OLC_TRIG(ch);

        } else {
    insert_trig_proto(OLC_TRIG(ch));
        }
                        
  OLC_TRIG(ch) = NULL;
  olc_add_to_save_list(zone_table[OLC_ZNUM(ch)].number, OLC_TRIGEDIT);
}
                

void dg_script_menu(char_data *ch)
{
  trig_data *edittrig = NULL;
  int i = 0;

  /* make sure our input parser gets used */
  OLC_MENU(ch) = SCRIPT_MAIN_MENU;

#if defined(CLEAR_SCREEN)
  send_to_char ("[H[J", ch);
#endif
  send_to_char ("Trigger List:\r\n", ch);

  if (OLC_SCRIPT(ch)) {
    edittrig = TRIGGERS(OLC_SCRIPT(ch));
    while (edittrig) {
      sprintf (buf, "%2d) [&cC%d&c0] &cC%s&c0\r\n", ++i,
               GET_TRIG_VNUM (edittrig),
               GET_TRIG_NAME (edittrig));
      send_to_char(buf, ch);

      edittrig = edittrig->next;
    }
  }

  if (!i)
    send_to_char ("     <none>\r\n", ch);

  strcpy(buf, "\r\n"
    " &cGN&c0)  New trigger for this script\r\n"
    " &cGD&c0)  Delete a trigger in this script\r\n"
	  " &cGQ&c0)  Exit Script Editor\r\n\r\n"
    "     Enter choice :");
  send_to_char(buf, ch);
}


int dg_script_edit_parse(char_data *ch, char *arg)
{
  int loc = -1, trigvnum = -1;
  struct int_list *list = NULL;

  switch (OLC_MENU(ch)) {
  case SCRIPT_MAIN_MENU:
    switch (*arg) {
    case 'q':
    case 'Q':
      switch (STATE(ch->desc)) {
      case CON_OEDIT: oedit_disp_menu(ch); break;
      case CON_MEDIT: medit_disp_menu(ch); break;
      case CON_REDIT: redit_disp_menu(ch); break;
      case CON_ZEDIT: zedit_disp_menu(ch); break;
      case CON_SEDIT: sedit_disp_menu(ch); break;
      case CON_TRIGEDIT: trigedit_disp_menu(ch); break;
          }
          return 0;
        case 'n':
    case 'N':
      send_to_char ("\r\nPlease enter trigger vnum : ", ch);
      OLC_MENU(ch) = SCRIPT_NEW_TRIGGER;
          break;
        case 'd':
    case 'D':
      send_to_char ("Which entry should be deleted?  0 to abort :", ch);
      OLC_MENU(ch) = SCRIPT_DEL_TRIGGER;
          break;
      }
      return 1;

    case SCRIPT_NEW_TRIGGER:
#ifdef GOT_RID_OF_IT
      vnum = -1;
      count = sscanf(arg,"%d, %d",&pos,&vnum);
      if (count==1) {
        vnum = pos;
        pos = 999;
      }
    if (pos <= 0)
      break;			/* this aborts a new trigger entry */

    if (vnum == 0)
      break;			/* this aborts a new trigger entry */

    if (trig_index[vnum] < 0) {
        send_to_char("Invalid Trigger VNUM!\r\n"
            "Please enter position, vnum   (ex: 1, 200):", ch);
        return 1;
      }

      /* add the new info in position */
      currtrig = OLC_SCRIPT(ch);
      CREATE(trig, struct trig_proto_list, 1);
      trig->vnum = vnum;

      if (pos==1 || !currtrig) {
        trig->next = OLC_SCRIPT(ch);
        OLC_SCRIPT(ch) = trig;
      } else {
        while (currtrig->next && --pos) {
          currtrig = currtrig->next;
        }
        trig->next = currtrig->next;
        currtrig->next = trig;
      }
#endif
    if ((*arg) && (*arg != '0')) {
      two_arguments(arg, buf2, buf3);

      if (*buf2)
    	trigvnum = atoi(buf2);
      if (trig_index[trigvnum] == NULL) {
    	send_to_char ("Invalid trigger vnum!\r\n", ch);
    	return 1;
      }

      if (*buf3)
    	loc = MAX(atoi(buf3), -1);

#ifdef GOT_RID_OF_IT
      // This seems to be a better approach to preventing bad trigger
      // attachments.  For some reason, adding two mismatched triggers
      // in a row was BAAAD news. -DH
      switch (GET_TRIG_ATTACH(PROTO_TRIG(trigvnum))) {
      case MOB_TRIGGER: if (STATE(ch->desc) != CON_MEDIT) trigvnum = -1; break;
      case OBJ_TRIGGER: if (STATE(ch->desc) != CON_OEDIT) trigvnum = -1; break;
      case WLD_TRIGGER: if (STATE(ch->desc) != CON_REDIT) trigvnum = -1; break;
      }
#endif
      
      if (trig_index[trigvnum] == NULL) {
    	send_to_char ("Invalid trigger vnum!\r\n", ch);
        dg_script_menu(ch);
    	return 1;
      }

      if (OLC_SCRIPT(ch) == NULL)
        OLC_SCRIPT(ch) = new script_data;

      add_trigger(OLC_SCRIPT(ch), new trig_data(PROTO_TRIG(trigvnum)), -1);
    }

    if (!OLC_SAVE(ch))
      OLC_SAVE(ch) = OLC_SAVE_YES;
      break;

    case SCRIPT_DEL_TRIGGER:
#ifdef GOT_RID_OF_IT
      pos = atoi(arg);
    if (pos <= 0)
      break;

      if (pos==1 && OLC_SCRIPT(ch)) {
      if (!OLC_SAVE(ch))
	OLC_SAVE(ch) = OLC_SAVE_YES;
        currtrig = OLC_SCRIPT(ch);
        OLC_SCRIPT(ch) = currtrig->next;
        free(currtrig);
        break;
      }
      pos--;
      currtrig = OLC_SCRIPT(ch);
    while (--pos && currtrig)
      currtrig = currtrig->next;
      /* now curtrig points one before the target */
      if (currtrig && currtrig->next) {
      if (!OLC_SAVE(ch))
	OLC_SAVE(ch) = OLC_SAVE_YES;
        trig = currtrig->next;
        currtrig->next = trig->next;
        free(trig);
      }
#endif
#ifdef GOT_RID_OF_IT
    loc = atoi(arg);
    tmptrigger = TRIGGERS(OLC_SCRIPT(ch));
    
    if ((loc) && (tmptrigger)) {
      while (tmptrigger) {
        if ((--loc) > 0) {
	  prevtrigger = tmptrigger;
	  tmptrigger = tmptrigger->next;
	} else {
	  if (prevtrigger) {
	    prevtrigger->next = tmptrigger->next;
	  } else {
	    TRIGGERS(OLC_SCRIPT(ch)) = tmptrigger->next;
	  }
	  tmptrigger->next = NULL;
          delete tmptrigger;
	  if (prevtrigger)
	    tmptrigger = prevtrigger->next;
	  else
	    tmptrigger = NULL;
	}
      }
      if (!OLC_SAVE(ch))
        OLC_SAVE(ch) = OLC_SAVE_YES;
    }
#endif
    if ((*arg) && (*arg != '0')) {
      remove_trigger(OLC_SCRIPT(ch), arg);
      if (!OLC_SAVE(ch))
        OLC_SAVE(ch) = OLC_SAVE_YES;
    }

      break;
  }

  dg_script_menu(ch);
  return 1;      
}
