/**************************************************************************
*  File: wldcmd.c                                                         *
*  Usage: contains the command_interpreter for rooms,                     *
*         room commands.                                                  *
*                                                                         *
*                                                                         *
*  $Author: tlo $
*  $Date: 1999/03/06 18:27:10 $
*  $Revision: 6.11 $
**************************************************************************/

#include "conf.h"
#include "sysdep.h"


#include "structs.h"
#include "screen.h"
#include "scripts.h"
#include "index.h"
#include "memory.h"
#include "utils.h"
#include "comm.h"
#include "interpreter.h"
#include "find.h"
#include "handler.h"
#include "db.h"
#include "constants.h"
#include "spells.h"

void die(struct char_data *ch, struct char_data *killer);
extern int find_owner_zone(int number);

extern void wld_command_interpreter(room_data * room, char *argument, int cmd = 0);
extern int genscript_command_interpreter(game_data * thing, char *argument, int cmd = 0);

#define WCMD(name)  \
    void (name)(room_data *room, char *argument, int cmd, int subcmd)


/* do_wsend */
#define SCMD_WSEND        0
#define SCMD_WECHOAROUND  1



/* attaches room vnum to msg and sends it to script_log */
void wld_log(room_data * room, char *msg)
{
    char buf[MAX_INPUT_LENGTH + 100];

    void script_log(char *msg);

    sprintf(buf, "Wld (room %d): %s", room->number, msg);
    script_log(buf);
}


/* World commands */

/* prints the argument to all the rooms aroud the room */
WCMD(do_wasound)
{
    do_scriptasound((game_data *) room, argument, cmd, subcmd, room->InRoom());
}


WCMD(do_wecho)
{
    do_scriptecho((game_data *) room, argument, cmd, subcmd, room->InRoom());
}


WCMD(do_wsend)
{
    do_scriptsend((game_data *) room, argument, cmd, subcmd, room->InRoom());
}


WCMD(do_wzoneecho)
{
    do_scriptzoneecho((game_data *) room, argument, cmd, subcmd, room->InRoom());
}


WCMD(do_wdoor)
{
    char target[MAX_INPUT_LENGTH], direction[MAX_INPUT_LENGTH];
    char field[MAX_INPUT_LENGTH], *value;
    room_data *rm;
    struct room_direction_data *exit;
    int dir, fd, to_room;

    static const char *door_field[] =
    {
	"purge",
	"description",
	"flags",
	"key",
	"name",
	"room",
	"\n"
    };


    argument = two_arguments(argument, target, direction);
    value = one_argument(argument, field);
    skip_spaces(&value);

    if (!*target || !*direction || !*field) {
	wld_log(room, "wdoor called with too few args");
	return;
    }
    if ((rm = get_room(target)) == NULL) {
	wld_log(room, "wdoor: invalid target");
	return;
    }
    if ((dir = search_block(direction, dirs, FALSE)) == -1) {
	wld_log(room, "wdoor: invalid direction");
	return;
    }

    if ((fd = search_block(field, door_field, FALSE)) == -1) {
	wld_log(room, "wdoor: invalid field");
	return;
    }

    exit = rm->dir_option[dir];

    /* purge exit */
    if (fd == 0) {
	if (exit) {
	    if (exit->general_description)
		FREE(exit->general_description);
	    if (exit->keyword)
		FREE(exit->keyword);
	    FREE(exit);
	    rm->dir_option[dir] = NULL;
	}
  } else {
	if (!exit) {
	    CREATE(exit, struct room_direction_data, 1);

	    rm->dir_option[dir] = exit; 
	}
	switch (fd) {
	case 1:  /* description */
	    if (exit->general_description)
		FREE(exit->general_description);
	    CREATE(exit->general_description, char, strlen(value) + 3);
	    strcpy(exit->general_description, value);
	    strcat(exit->general_description, "\r\n");
	    break;
	case 2:  /* flags       */
	    exit->exit_info = asciiflag_conv(value);
	    break;
	case 3:  /* key         */
	    exit->key = atoi(value);
	    break;
	case 4:  /* name        */
	    if (exit->keyword)
		FREE(exit->keyword);
	    CREATE(exit->keyword, char, strlen(value) + 1);
	    strcpy(exit->keyword, value);
	    break;
	case 5:  /* room        */
	    if ((to_room = real_room(atoi(value))) != NOWHERE)
		exit->to_room = to_room;
	    else
		wld_log(room, "wdoor: invalid door target");
	    break;
	}
    }
}


WCMD(do_wteleport)
{
    do_scriptteleport((game_data *) room, argument, cmd, subcmd, room->InRoom());
}


WCMD(do_wforce)
{
    do_scriptforce((game_data *) room, argument, cmd, subcmd, room->InRoom());
}


/* increases the target's exp */
WCMD(do_wexp)
{
    do_scriptexp((game_data *) room, argument, cmd, subcmd, room->InRoom());
}


/* purge all objects an npcs in room, or specified object or mob */
WCMD(do_wpurge)
{
    do_scriptpurge((game_data *) room, argument, cmd, subcmd, room->InRoom());
}


/* loads a mobile or object into the room */
WCMD(do_wload)
{
    do_scriptload((game_data *) room, argument, cmd, subcmd, room->InRoom());
}


WCMD(do_wdamage)
{
    do_scriptdamage((game_data *) room, argument, cmd, subcmd, room->InRoom());
}


WCMD(do_wset)
{
    do_scriptsetchar((game_data *) room, argument, cmd, subcmd, room->InRoom());
}

WCMD(do_wat)
{
    char location[MAX_INPUT_LENGTH], arg2[MAX_INPUT_LENGTH];
    int vnum = 0;    
    room_data *r2;
 
    half_chop(argument, location, arg2);

    if (!*location || !*arg2 || !isdigit(*location)) {
	wld_log(room, "wat: bad syntax");
	return;
    }
    vnum = atoi(location);
    if (NOWHERE == real_room(vnum)) {
	wld_log(room, "wat: location not found");
	return;
    }

    r2 = world[vnum];
    wld_command_interpreter(r2, arg2);
}


WCMD(do_wskillset)
{
    do_scriptskillset((game_data *) room, argument, cmd, subcmd, room->InRoom());
}


const struct wld_command_info wld_cmd_info[] =
{
  {"RESERVED", 0, 0},		/* this must be first -- for specprocs */
    
  {"wasound", do_wasound, 0},
  {"wdoor", do_wdoor, 0},
  {"wechoaround", do_wsend, SCMD_WECHOAROUND},
  {"wecho", do_wecho, 0},
  {"wexp", do_wexp, 0},
  {"wforce", do_wforce, 0},
  {"wload", do_wload, 0},
  {"wpurge", do_wpurge, 0},
  {"wsend", do_wsend, SCMD_WSEND},
  {"wteleport", do_wteleport, 0},
  {"wzoneecho", do_wzoneecho, 0},
  {"wdamage", do_wdamage, 0},
  {"wat", do_wat, 0},
  {"wskillset", do_wskillset, 0},
  {"wset", do_wset, 0},
  {"\n", 0, 0}			/* this must be last */
};


/*
 *  This is the command interpreter used by rooms, called by script_driver.
 */
void wld_command_interpreter(room_data * room, char *argument, int cmd = 0)
{
    int length;
    char *line, arg[MAX_INPUT_LENGTH];
  
    if (!cmd && genscript_command_interpreter((game_data *) room, argument, -1)) {
      return;
    }
  
    skip_spaces(&argument);
  
    /* just drop to next line for hitting CR */
    if (!*argument)
	return;

    line = any_one_arg(argument, arg);

    if (cmd <= 0) {
      /* find the command */
      cmd = 0;
      for (length = strlen(arg); *wld_cmd_info[cmd].command != '\n'; ++cmd)
        if (!strncmp(wld_cmd_info[cmd].command, arg, length))
          break;
    }
  
    if (*wld_cmd_info[cmd].command == '\n') {
	sprintf(buf2, "Unknown world cmd: '%s'", argument);
	wld_log(room, buf2);
    } else
	((*wld_cmd_info[cmd].command_pointer) 
	 (room, line, cmd, wld_cmd_info[cmd].subcmd));
}
