/*
 *******************************************************************
 * dnslist - List the contents of the dnscache 
 *
 * This is a companion module to aowdns.c... 
 *
 * Compile: gcc -o dnslist dnslist.c -g -lndbm
 *
 * Sample invocation: ./dnslist dnscache    (leave the .db off)
 *
 * This code may be freely distributed and modified as you like.
 * No license whatsover is required.  However, I would appreciate it
 * if you kept this notice and my name intact.
 *
 * Author: Reed H. Petty, Server Admin and Sometimes Coder
 *	   AgeofWar.ORG Port 4000
 *	   rhp@draper.net
 *******************************************************************
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <ndbm.h>
#include <string.h>
#include <errno.h>

int main(int argc, char **argv)
{
	struct dns_file {
		time_t created;
		char name[80];
	} dnsrec;

	int dnskey = 0;
	datum key_datum;
	datum data_datum;
	DBM *dbm_ptr;

	if (argc < 2) {
		printf("Usage: dnslist filename\n");
		exit(1);
	}
	
	if (!(dbm_ptr = dbm_open(argv[1], O_RDWR, 0600))) {
		perror("database open failed");
		exit(1);
	}

	for (key_datum=dbm_firstkey(dbm_ptr); key_datum.dptr; 
			key_datum=dbm_nextkey(dbm_ptr)) {

		data_datum = dbm_fetch(dbm_ptr, key_datum);
		memcpy(&dnsrec,data_datum.dptr,data_datum.dsize);
		memcpy(&dnskey,key_datum.dptr,key_datum.dsize);
		
		fprintf(stdout,"%03u.%03u.%03u.%03u  %d %s\n",
			(dnskey & 0x000000FF), 
			(dnskey & 0x0000FF00) >> 8,
			(dnskey & 0x00FF0000) >> 16,
			(dnskey & 0xFF000000) >> 24,
			dnsrec.created, 
			dnsrec.name);
	}
	
	dbm_close(dbm_ptr);
}
