ACT_OTHER_C --> Addition to ACT.OTHER.C

< SECTION 1 >

/* -^- *** YORU'S ROMANCE MODULE     *** -^-
		** Romance For CircleMUD 3.0 **
		 *  Special Thanks to:       *
	 Rawther and Liran of AugMUD for their help! */
/* Extra Thanks to Philip Ames for help debugging V 0.92 */
/* Extra Thanks to Brian Finley for help debugging V 0.9/0.92.2b */

void namesave(struct char_data *ch, struct char_data *vict) {
	/* Saves the names in PARTNER() */
		/* Now we're set! Save it! */
	struct char_file_u ch_st;
	struct char_file_u vict_st;

		save_char(ch, NOWHERE);
		Crash_crashsave(ch);
		if (ROOM_FLAGGED(ch->in_room, ROOM_HOUSE_CRASH))
			House_crashsave(GET_ROOM_VNUM(IN_ROOM(ch)));
		save_char(vict, NOWHERE);
		Crash_crashsave(vict);
		if (ROOM_FLAGGED(vict->in_room, ROOM_HOUSE_CRASH))
			House_crashsave(GET_ROOM_VNUM(IN_ROOM(vict)));
		// Saved, now reorient Partner via a load.
		if(load_char(GET_NAME(vict), &vict_st) < 0) {
			send_to_char("Error: Cannot Load VICT\r\n", vict);
			return;
		}
		if(load_char(GET_NAME(ch), &ch_st) < 0) {
			send_to_char("Error: Cannot Load CH\r\n", ch);
			return;
		}
		PARTNER(ch) = str_dup(ch_st.partner); // Set Ch's PARTNER name
		PARTNER(vict) = str_dup(vict_st.partner); // Set Vict's PARTNER name
}

void changesave(struct char_data *ch, struct char_data *vict) {
	/* Saves changes after rejection */
	save_char(ch, NOWHERE);
			Crash_crashsave(ch);
			if (ROOM_FLAGGED(ch->in_room, ROOM_HOUSE_CRASH))
				House_crashsave(GET_ROOM_VNUM(IN_ROOM(ch)));
			save_char(vict, NOWHERE);
			Crash_crashsave(vict);
			if (ROOM_FLAGGED(vict->in_room, ROOM_HOUSE_CRASH))
				House_crashsave(GET_ROOM_VNUM(IN_ROOM(vict)));
}

int check_samesex(struct char_data *ch, struct char_data *victim)
{
	/*Checks if it's a same-sex proposition/marriage */
	/* Then checks if SAME_SEX_ALLOWED is TRUE. */
	/* If the proposition is same-sex, and SAME_SEX_ALLOWED */
	/* is FALSE, then it returns 1, which will halt the procedure. */
	/* Otherwise, if SAME_SEX_ALLOWED is TRUE or the proposition is */
	/* NOT same-sex, it returns 0, and things continue as normal */
	if((GET_SEX(ch) == GET_SEX(victim)) && (SAME_SEX_ALLOWED == FALSE))
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

/* Romance Module -- Ask Someone Out */
ACMD(do_askout)
{
	struct char_data *victim;

	one_argument(argument, arg);
	if (!*arg) { /* What, ask no one out? */
		send_to_char("Uh, whom do you wish to ask out?\r\n", ch);
        return;
	}
	else if (!(victim = get_char_room_vis(ch, arg))) {
		/* Is that person here? Nope! */
		send_to_char(NOPERSON, ch);
		return;
	}
	if (ROMANCE(ch) != 0) { /* Are you already involved? */
		send_to_char("Sorry, you're already romantically involved!\r\n", ch);
		return;
	}
	else if (crashcheck_alpha(victim, ch) == 1)
		{
			return;
		}
	else if (ROMANCE(victim) != 0) { /* Is the person you're propositioning to involved? */
		send_to_char("Try propositioning someone who ISN'T already romantically involved!\r\n", ch);
		return;
	}
	else if (victim == ch) {
		/* Ask yourself out?!? */
		send_to_char("Sorry, but you cannot ask yourself out!\r\n", ch);
		return;
	}
	else if (check_samesex(ch, victim) == 1) {
		/* Check if it's same-sex, and if same-sex is allowed. */
		send_to_char("Sorry, same-sex relations are not allowed here.\r\n", ch);
	    return;
	}
	else if(ROMANCE(ch) == -3) {
		send_to_char("Sorry, you have to turn romance on before asking someone out.\r\n", ch);
		return;
	}
	else if(ROMANCE(victim) == -3) {
		send_to_char("Sorry, they've got romance turned off for the moment..\r\n", ch);
		return;
	}
	else { /* Okay, now we do that actual asking out.. */

	act("You ask $N out...\r\n", TRUE, ch, 0, victim, TO_CHAR);
	act("$n is asking you out!\r\n", TRUE, ch, 0, victim, TO_VICT);
	act("$n asks $N out on a date!\r\n", TRUE, ch, 0, victim, TO_NOTVICT);
	ROMANCE(victim) = ASKED_OUT; /* Now they're being asked out. */
	ROMANCE(ch) = ASKING; /* Temporarily declare the person as being asked out.. */
	  /* NOTE: PARTNER(ch) must be reset in DO_REJECT */
	/* At this point, the Victim can either ACCEPT or REJECT the proposition. */
	}
}

/* Romance Module -- Accept a Proposition */

ACMD(do_accept)
{
	struct char_data *victim;
	if(ROMANCE(ch) < ASKED_OUT) { /* You're not being asked out.. */
		send_to_char("You're not being romantically propositioned..\r\n", ch);
		return;
	}
	else { /* Okay, you've been asked out or proposed to.. */
		one_argument(argument, arg);
		if(!*arg) { /* Accept no one? */
			send_to_char("Who do you want to accept?\r\n", ch);
			return;
		}
		else if(!(victim = get_char_room_vis(ch, arg))) {
			/* Are they here? No! */
			send_to_char(NOPERSON, ch);
			return;
		}
		else if(victim == ch) { /* Accept yourself? */
			send_to_char("You can't accept yourself as a partner!\r\n", ch);
			return;
		}
		else if (crashcheck_alpha(victim, ch) == 1)
		{
			return;
		}
		else if(ROMANCE(victim) < ASKING) /* Are they propositioning as well? */ {
			send_to_char("But they're not asking you out!\r\n", ch);
			return;
		}
		else if(check_samesex(ch, victim) == 1) {
			/* Check for same-sex relations.. */
			send_to_char("Sorry, same-sex relationships are not allowed here.\r\n", ch);
			/* Okay, they've been corrected. The tick-timer will expire the
			ROMANCE factor on it's own. */
			return;
		}
		else { /* Okay, all the tests pass.. */
			if((ROMANCE(ch) == ASKED_OUT) && (ROMANCE(victim) == ASKING)) {
				/* For dating.. */
				act("You agree to date $N!\r\n", TRUE, ch, 0, victim, TO_CHAR);
				act("$n has agreed to date you!\r\n", TRUE, ch, 0, victim, TO_VICT);
				act("$n agrees to date $N!\r\n", TRUE, ch, 0, victim, TO_NOTVICT);
				/* We've notified them, now change the variables. */
				PARTNER(ch) = GET_NAME(victim);
				PARTNER(victim) = GET_NAME(ch);
				ROMANCE(ch) = 1;
				ROMANCE(victim) = 1;
				/* Now they're set as partners, and they've been set at Dating. */
				namesave(ch, victim); // Reorient PARTNER()s
				return;
			}
			else if((ROMANCE(ch) == PROPOSED_TO) && (ROMANCE(victim) == ASKING)) {
				/* For engagement.. */
				act("You agree to marry $N!\r\n", TRUE, ch, 0, victim, TO_CHAR);
				act("$n has agreed to marry you!\r\n", TRUE, ch, 0, victim, TO_VICT);
				act("$n agrees to marry $N!\r\n", TRUE, ch, 0, victim, TO_NOTVICT);
				/* We've done the notification, now change the variables. */
				PARTNER(ch) = GET_NAME(victim);
				PARTNER(victim) = GET_NAME(ch); /* Just in case... */
				ROMANCE(ch) = 2;
				ROMANCE(victim) = 2;
				/* Now they're engaged and partnered.. */
				namesave(ch, victim); // Reorient PARTNER()s
				return; /* Get the hell outta this command. */
			}
			else { /* They're not propositioning you after all. */
				send_to_char("That person isn't propositioning you..\r\n", ch);
				return;
			}
		}
	}
}

/* Romance Module -- Reject A Proposition */
ACMD(do_reject)
{
	struct char_data *victim;
	char tempname[MAX_NAME_LENGTH+1];
 	if(ROMANCE(ch) < ASKED_OUT) { /* You're not being asked out.. */
		send_to_char("You're not being romantically propositioned..\r\n", ch);
		return;
	}
	else { /* Okay, you've been asked out or proposed to.. */
		one_argument(argument, arg);
		if(!*arg) { /* Reject no one? */
			send_to_char("Whose heart do you wish to break?\r\n", ch);
			return;
		}
		else if(!(victim = get_char_room_vis(ch, arg))) {
			/* Are they here? No! */
			send_to_char(NOPERSON, ch);
			return;
		}
		else if(victim == ch) { /* Reject yourself? */
			send_to_char("You can't reject yourself!\r\n", ch);
			return;
		}
		else if (crashcheck_alpha(victim, ch) == 1)
		{
			return;
		}
		else if(ROMANCE(victim) < ASKING) /* Are they propositioning as well? */ {
			send_to_char("But they're not asking you out!\r\n", ch);
			return;
		}
		else if(check_samesex(ch, victim) == 1) {
			/* Uh, they couldn't have asked you out. */
			send_to_char("Sorry, but that person isn't propositioning you.\r\n", ch);
			return;
		}
		else { /* Okay, all the tests pass.. */
			if ((ROMANCE(ch) == ASKED_OUT) && (ROMANCE(victim) == ASKING)) {
				/* For dating.. */
			act("You tell $N that you'd rather just be friends.\r\n", TRUE, ch, 0, victim, TO_CHAR);
			send_to_char(buf, ch);
			sprintf(buf, "$n would rather just be 'friends', but you feel your heart shatter into a thousand pieces.\r\n", TRUE, ch, 0, victim, TO_VICT);
			act("$n rejects $N! How cold!\r\n", TRUE, ch, 0, victim, TO_NOTVICT);
			PARTNER(victim) = NULL;
			PARTNER(ch) = NULL;
			ROMANCE(victim) = 0;
			ROMANCE(ch) = 0;
			changesave(ch, victim);
			return;
			}
			else if ((ROMANCE(ch) == PROPOSED_TO) && (ROMANCE(victim) == ASKING)) {
				/* For marriage proposals... */
			send_to_char("You decide you'd rather not get married just yet.\r\n", ch);
			act("$n doesn't want to get married just yet..\r\n", TRUE, ch, 0, victim, TO_VICT);
			act("$n hands $N's ring back to $S.\r\n", TRUE, ch, 0, victim, TO_NOTVICT);
				PARTNER(ch) = GET_NAME(victim);
				PARTNER(victim) = GET_NAME(ch);
			/* Just in case. */
			ROMANCE(victim) = 1;
			ROMANCE(ch) = 1; /* Back to "Dating" status. */
			namesave(ch, victim);
			return;
			}
			else { /* Oops! They're not asking you after all! */
				send_to_char("But they're not propositioning you!\r\n", ch);
				return;
			}
		}
	}
}

/* Romance Module -- Propose Marriage */
ACMD(do_propose)
{
	/* To propose to someone. */
	struct char_data *victim;
	if(ROMANCE(ch) < 1) { /* Are you already dating? */
		send_to_char("But you're not dating anyone!\r\n", ch);
		return;
	}
	else if (ROMANCE(ch) == 2) { /* Are you already engaged? */
		send_to_char("But you're already engaged!\r\n", ch);
		return;
	}
	else if (ROMANCE(ch) == 3) { /* Are you already married? */
		sprintf(buf, "But you're married already! %s wouldn't approve!\r\n", PARTNER(ch));
		send_to_char(buf, ch);
		return;
	}
	else if (ROMANCE(ch) == 4) { /* Are you being asking out by someone? */
		send_to_char("But you're being asked out! That would be rude!\r\n", ch);
		return;
	}
	else if (ROMANCE(ch) == 5) { /* Are you already proposing? */
		send_to_char("But you're already proposing!\r\n", ch);
		return;
	}
	else if (ROMANCE(ch) == ASKING) { /*Asking someone out? */
		send_to_char("But you're asking someone else!\r\n", ch);
		return;
	}
	else if (ROMANCE(ch) > 6) { /* Any errors in the module? */
		send_to_char("ERROR IN ROMANCE MODULE: Romance Factor > 6!\r\n", ch);
		return;
	}
	else { /* Okay, YOU pass... */
	one_argument(argument, arg);
		if(!*arg) { /* Propose to no one? */
			send_to_char("Whom do you want to propose to?\r\n", ch);
			return;
		}
		else if(!(victim = get_char_room_vis(ch, arg))) {
			/* Are they here? No! */
			send_to_char(NOPERSON, ch);
			return;
		}
		else if(victim == ch) { /* Propose to yourself? */
			send_to_char("You can't propose to yourself!\r\n", ch);
			return;
		}
		else if (crashcheck_alpha(victim, ch) == 1)
		{
			return;
		}
		else if(ROMANCE(victim) < 1) { /* Are they already dating? */
		send_to_char("But they're not dating anyone!\r\n", ch);
		return;
		}
		else if (ROMANCE(victim) == 2) { /* Are they already engaged? */
		sprintf(buf, "But they're already engaged to %s!\r\n", PARTNER(victim));
		send_to_char(buf, ch);
		return;
		}
		else if (ROMANCE(victim) == 3) { /* Are they already married? */
		sprintf(buf, "But they're married already! %s wouldn't approve!\r\n", PARTNER(victim));
		send_to_char(buf, ch);
		return;
		}
		else if (ROMANCE(victim) == 4) { /* Are they being asked out? */
		send_to_char("But they're being asked out! That would be rude!\r\n", ch);
		return;
		}
		else if (ROMANCE(victim) == 5) { /* Are they already proposing? */
		send_to_char("But they're already proposing!\r\n", ch);
		return;
		}
		else if (ROMANCE(victim) == 6) { /*Asking someone? */
			send_to_char("But they're already asking someone else!\r\n", ch);
			return;
		}
		else if (ROMANCE(victim) > 6) { /* Any errors in the module? */
		send_to_char("ERROR IN ROMANCE MODULE: Romance Factor > 5!\r\n", ch);
		return;
		}
		/* Okay, we've established you're both dating someone.. */
		else if (PARTNER(ch) != GET_NAME(victim)) {
			/* But are you dating them? */
			sprintf(buf, "But you're not dating %s!\r\n", GET_NAME(victim));
			send_to_char(buf, ch);
			return;
		}
		else if (*PARTNER(victim) != *GET_NAME(ch)) {
			/* Are they dating you? We shouldn't need this, though.. */
			sprintf(buf, "But %s isn't dating you!\r\n", GET_NAME(victim));
			send_to_char(buf, ch);
			return;
		}
		/* Okay, you're dating each other, now we can get on with it! */
		else {
			act("You kneel in front of $N and ask for $S hand in marriage!\r\n", TRUE, ch, 0, victim, TO_CHAR);
			act("$n kneels before you and asks for your hand in marriage!\r\n", TRUE, ch, 0, victim, TO_VICT);
			act("$n kneels before $N, asking for $S hand in marriage!\r\n", TRUE, ch, 0, victim, TO_NOTVICT);
			/* We've informed the world, now change the vars.. */
			ROMANCE(ch) = ASKING;
			ROMANCE(victim) = PROPOSED_TO;
			/* Now all the partner has to do is accept or reject. */
			return;
		}
	}
}

/* Romance Module: Break up */

ACMD(do_breakup)
{
	struct char_data *victim;
 /* First, standard checks: Are you in a relationship? */
	if (ROMANCE(ch) == 0) {
		send_to_char("But you're not romantically involved!\r\n", ch);
		return;
	}
	else if (ROMANCE(ch) == 3) {
		sprintf(buf, "But you're already married! You have to DIVORCE %s!\r\n", PARTNER(ch));
		send_to_char(buf, ch);
		return;
	}
	else {
		/* Okay, you're involved.. */
		one_argument(argument, arg);
		if(!*arg) { /* Break up with noone? */
			send_to_char("Whom do you want to break up with?\r\n", ch);
			return;
		}
		else if(!(victim = get_char_room_vis(ch, arg))) {
			/* Are they here? No! */
			send_to_char(NOPERSON, ch);
			return;
		}
		else if(victim == ch) { /* Break up with yourself? */
			send_to_char("You can't break up with yourself!\r\n", ch);
			return;
		}
		else if (crashcheck_alpha(victim, ch) == 1)
		{
			return;
		}
		else if (ROMANCE(victim) == 0) {
		send_to_char("But they're not romantically involved!\r\n", ch);
		return;
		}
		else if ((ROMANCE(victim) == 1) && (*PARTNER(victim) != *GET_NAME(ch)))
		{
			sprintf(buf, "But they're dating %s, not you!\r\n", PARTNER(victim));
			send_to_char(buf, ch);
			return;
		}
		else if ((ROMANCE(victim) == 2) && (*PARTNER(victim) != *GET_NAME(ch)))
		{
			sprintf(buf, "But they're engaged to %s, not you!\r\n", PARTNER(victim));
			send_to_char(buf, ch);
			return;
		}
		else if ((ROMANCE(victim) == 3) && (*PARTNER(victim) != *GET_NAME(ch)))
		{
			sprintf(buf, "But they're married to %s, not you!\r\n", PARTNER(victim));
			send_to_char(buf, ch);
			return;
		}
		else if ((ROMANCE(victim) == 3) && (*PARTNER(victim) == *GET_NAME(ch)))
		{
			sprintf(buf, "They're already married to you! You have to DIVORCE %s!\r\n", GET_NAME(victim));
			send_to_char(buf, ch);
			return;
		}
		else if (*PARTNER(victim) != *GET_NAME(ch)) {
			sprintf(buf, "But %s isn't involved with you!\r\n", GET_NAME(victim));
			send_to_char(buf, ch);
			return;
		}
		else {
			/* Okay, they're involved and with you... */
			/* Now we break them up! How FUN! */
			if ((ROMANCE(ch) == 1) && (ROMANCE(victim) == 1)) {
				/* For dating */
			act("You inform $N that you will no longer date $S!\r\n", TRUE, ch, 0, victim, TO_CHAR);
			act("$n dumps you, tearing your heart out in the process!\r\n", TRUE, ch, 0, victim, TO_VICT);
			act("$n sends $s relationship with $N to Splitsville!\r\n", TRUE, ch, 0, victim, TO_NOTVICT);
			/* Now set the variables to 0 */
			PARTNER(ch) = NULL;
			PARTNER(victim) = NULL;
			ROMANCE(ch) = 0;
			ROMANCE(victim) = 0;
			namesave(ch, victim);
			/* Done. You've dumped them. */
			return;
			}
			else if ((ROMANCE(ch) == 2) && (ROMANCE(victim) == 2)) {
				/* For engagements */
			act("You call off your wedding with $N.\r\n", TRUE, ch, 0, victim, TO_CHAR);
			act("$n doesn't want to marry you anymore! The wedding's off!\r\n", TRUE, ch, 0, victim, TO_VICT);
			act("$n nullifies $s engagement with $N! The wedding's off!\r\n", TRUE, ch, 0, victim, TO_NOTVICT);
			/* Now set the variables to 0 */
			PARTNER(ch) = NULL;
			PARTNER(victim) = NULL;
			ROMANCE(ch) = 0;
			ROMANCE(victim) = 0;
			namesave(ch, victim);
			/* Done. You've dumped them. */
			return;
			}
			else if ((ROMANCE(ch) == 4) && (ROMANCE(victim) == 4)) {
				/* For dating/askouts */
			act("You inform $N that you no longer wish to date $S!\r\n", TRUE, ch, 0, victim, TO_CHAR);
			act("$n doesn't feel like dating you anymore!\r\n", TRUE, ch, 0, victim, TO_VICT);
			act("$n decides not to date $N.\r\n", TRUE, ch, 0, victim, TO_NOTVICT);
			/* Now set the variables to 0 */
			PARTNER(ch) = NULL;
			PARTNER(victim) = NULL;
			ROMANCE(ch) = 0;
			ROMANCE(victim) = 0;
			namesave(ch, victim);
			/* Done. You've dumped them. */
			return;
			}
			else if ((ROMANCE(ch) == 5) && (ROMANCE(victim) == 5)) {
				/* For engagements/proposals */
			act("You cancel your wedding proposal to $N.\r\n", TRUE, ch, 0, victim, TO_CHAR);
			act("$n doesn't want to marry you anymore!\r\n", TRUE, ch, 0, victim, TO_VICT);
			act("$n nullifies $s engagement proposal with $N!\r\n", TRUE, ch, 0, victim, TO_NOTVICT);
			/* Now set the variables to back to Dating */
			/* This is the only exception. You can change it to cancel
				Dating status as well. */
			ROMANCE(ch) = 1;
			ROMANCE(victim) = 1;
			/* Done. You've cancelled your proposal them. */
			return;
			}
			else { /* Guess you're not involved after all. */
				sprintf(buf, "But you're not involved with %s!", GET_NAME(victim));
				send_to_char(buf, ch);
				return;
			}
		}
	}
}

/* Function for the actual marriage */
void marry_them (struct char_data *ch, struct char_data *victim, struct char_data *imm)
{
	struct char_file_u ch_st;
	struct char_file_u vict_st;
 /* Do standard checks.. */
	 if (crashcheck_alpha(victim, imm) == 1)
		{
			return;
		}
	 else if (crashcheck_alpha(ch, imm) == 1)
		{
			return;
		}
	 if (ROMANCE(ch) != 2) {
		/* Groom isn't engaged */
		sprintf(buf, "But %s isn't engaged!\r\n", GET_NAME(ch));
		send_to_char(buf, imm);
		return;
	}
	else if (ROMANCE(victim) != 2) {
		/* Bride isn't engaged */
		sprintf(buf, "But %s isn't engaged!\r\n", GET_NAME(victim));
		send_to_char(buf, imm);
		return;
	}
	else if (*PARTNER(ch) != *GET_NAME(victim)) {
		/* Not engaged to each other */
		send_to_char("But they're not engaged to each other!\r\n", imm);
		return;
	}
	else if (*PARTNER(victim) != *GET_NAME(ch)) {
		/* Not engaged to each other */
		send_to_char("But they're not engaged to each other!\r\n", imm);
		return;
	}
	else if (check_samesex(ch, victim) == 1) {
		/* Same Sex Marriages? */
		send_to_char("Same-sex marriages are not allowed.\r\n", imm);
		return;
	}
	else {
		if (GET_SEX(ch) != GET_SEX(victim)) {
			/* Regular Marriage */
		/* They're engaged to each other, now perform the marriage. */
		sprintf(buf, "%s declares you married to %s!\r\n", GET_NAME(imm), PARTNER(ch));
		send_to_char(buf, ch);
		sprintf(buf, "%s declares you married to %s!\r\n", GET_NAME(imm), PARTNER(victim));
		send_to_char(buf, victim);
		sprintf(buf, "You declare %s and %s man and wife!\r\n", GET_NAME(ch), GET_NAME(victim));
		send_to_char(buf, imm);
		sprintf(buf, "%s declares %s and %s man and wife!\r\n", GET_NAME(imm), GET_NAME(ch), GET_NAME(victim));
		act(buf, TRUE, 0, 0, 0, TO_ROOM);
		}
		else { /* Same-sex Marriage */
		sprintf(buf, "%s declares you married to %s!\r\n", GET_NAME(imm), PARTNER(ch));
		send_to_char(buf, ch);
		sprintf(buf, "%s declares you married to %s!\r\n", GET_NAME(imm), PARTNER(victim));
		send_to_char(buf, victim);
		sprintf(buf, "You declare %s and %s married!\r\n", GET_NAME(ch), GET_NAME(victim));
		send_to_char(buf, imm);
		sprintf(buf, "%s declares %s and %s married!\r\n", GET_NAME(imm), GET_NAME(ch), GET_NAME(victim));
		act(buf, TRUE, 0, 0, 0, TO_NOTVICT);
		}
		PARTNER(ch) = GET_NAME(victim);
		PARTNER(victim) = GET_NAME(ch);
		/* Just in case! */
		ROMANCE(ch) = 3;
		ROMANCE(victim) = 3;
		/* Now we're set! Save it! */
		namesave(ch, victim);
		return;
	}
}

/* Romance Module -- Marry Two People */
/* THIS SHOULD BE AN IMM-LEVEL COMMAND! */

ACMD(do_marry)
{
	struct char_data *groom;
	struct char_data *bride;
	char groom_name [MAX_INPUT_LENGTH];
	char bride_name [MAX_INPUT_LENGTH];
  argument = one_argument(argument, groom_name);
  one_argument(argument, bride_name);
 if(!(groom = get_char_room_vis(ch, groom_name))) {
			/* Are they here? No! */
			send_to_char(NOPERSON, ch);
			return;
		}
 else if(!(bride = get_char_room_vis(ch, bride_name))) {
			/* Are they here? No! */
			send_to_char(NOPERSON, ch);
			return;
	}
 if (groom_name == bride_name) {
	 /* Groom is the Bride? */
	 send_to_char("You can't marry someone to themself!\r\n", ch);
	 return;
 }
 else if (groom == ch)
 {
	 /* Can't perform a ceremony on yourself. */
	 send_to_char("Sorry, you have to get someone ELSE to perform the ceremony!\r\n", ch);
	 return;
 }
  else if (bride == ch)
 {
	 /* Can't perform a ceremony on yourself. */
	 send_to_char("Sorry, you have to get someone ELSE to perform the ceremony!\r\n", ch);
	 return;
 }
 else if ((!groom) || (!bride)) {
                send_to_char("Which couple do you wish to marry?\r\n", ch);
                return;
        }
 else { /* Let the marry function check the rest. */
	 marry_them(groom, bride, ch);
 }
}

/* Romance Module - Divorce */

ACMD(do_divorce)
{
struct char_data *victim;
 /* First, standard checks: Are you in a relationship? */
	if (ROMANCE(ch) != 3) {
		send_to_char("But you're not married!\r\n", ch);
		return;
	}
	else {
		/* Okay, you're involved.. */
		one_argument(argument, arg);
		if(!*arg) { /* Break up with noone? */
			send_to_char("Whom do you want to divorce?\r\n", ch);
			return;
		}
		else if(!(victim = get_char_room_vis(ch, arg))) {
			/* Are they here? No! */
			send_to_char(NOPERSON, ch);
			return;
		}
		else if(victim == ch) { /* Break up with yourself? */
			send_to_char("You can't divorce yourself!\r\n", ch);
			return;
		}
		else if (crashcheck_alpha(victim, ch) == 1)
		{
			return;
		}
		else if (ROMANCE(victim) == 0)
		{
		send_to_char("But they're not romantically involved!\r\n", ch);
		return;
		}
		else if ((ROMANCE(victim) == 1) && (*PARTNER(victim) != *GET_NAME(ch)))
		{
			sprintf(buf, "But they're dating %s, not you!\r\n", PARTNER(victim));
			send_to_char(buf, ch);
			return;
		}
		else if ((ROMANCE(victim) == 2) && (*PARTNER(victim) != *GET_NAME(ch)))
		{
			sprintf(buf, "But they're engaged to %s, not you!\r\n", PARTNER(victim));
			send_to_char(buf, ch);
			return;
		}
		else if ((ROMANCE(victim) == 3) && (*PARTNER(victim) != *GET_NAME(ch)))
		{
			sprintf(buf, "But they're married to %s, not you!\r\n", PARTNER(victim));
			send_to_char(buf, ch);
			return;
		}
		else if (*PARTNER(victim) != *GET_NAME(ch)) {
			sprintf(buf, "But %s isn't involved with you!\r\n", GET_NAME(victim));
			send_to_char(buf, ch);
			return;
		}
		else {
			/* Okay, they're involved and with you... */
			/* Now we break them up! How FUN! */
			act("You yank $N's wedding ring off and throw it on the floor!\r\n", TRUE, ch, 0, victim, TO_CHAR);
			act("$n yanks $s wedding ring off and throws it on the floor!\r\n", TRUE, ch, 0, victim, TO_VICT);
			act("$n yanks $s wedding ring from $N off and throws it on the floor! DIVORCE!\r\n", TRUE, ch, 0, victim, TO_NOTVICT);
			PARTNER(ch) = NULL;
			PARTNER(victim) = NULL;
			ROMANCE(ch) = 0;
			ROMANCE(victim) = 0;
			/* It's all reset, save changes. */
			changesave(ch, victim);
		}
	}
}

int crashcheck_alpha (struct char_data *ch, struct char_data *vict)
{
	/* Just some crash-preventing checks. */
	/* Returns 1 to indicate a crash will occur. */
	/* Return 0 if everything's ok */
	if(ch->in_room == -1)
	{
		return 1;
	}
	else if (IS_NPC(ch))
	{
		send_to_char("You have to do that to a player!\r\n", vict);
		return 1;
	}
	else if (IS_NPC(vict))
	{
		send_to_char("You can't do that!\r\n", vict);
		return 1;
	}
	else if(GET_POS(ch) < POS_RESTING)
	{
		send_to_char("You can't do that now!\r\n", vict);
		return 1;
	}
	else
	{
		return 0;
	}
}

/* MatingMod ACMDs and functions */
/* MATINGMOD v0.93 by Yoru-Hikage */
/* Special Thanks to Rawther (formerly) of AugMUD for his help */

/* First command, to conceive */
ACMD(do_conceive)
{
	struct char_data *victim;
	one_argument(argument, arg);
	if(!*arg) { /* Mate with noone? */
	send_to_char("Whom do you want to mate with?\r\n", ch);
	return;
	}
	else if(!(victim = get_char_room_vis(ch, arg))) {
	/* Are they here? No! */
	send_to_char(NOPERSON, ch);
	return;
	}
	else if(victim == ch) { /* Mate with yourself? */
	send_to_char("You can't mate with yourself!\r\n", ch);
	return;
	}
	if(GET_SEX(ch) == SEX_MALE)
	{
		send_to_char("Hey, only women can have kids..\r\n", ch);
		return;
	}
	else if(GET_SEX(victim) == SEX_FEMALE)
	{
		send_to_char("You need a male partner to conceive.\r\n", ch);
		return;
	}
	if ((ROMANCE(ch) != 3) && (OUT_OF_WEDLOCK == FALSE))
	{
		send_to_char("Sorry, children may not be conceived out of wedlock here.\r\n", ch);
		return;
	}
	if (crashcheck_alpha(victim, ch) == 1)
	{
		return;
	}
	if (GET_POS(ch) == POS_FIGHTING)
	{
		send_to_char("You can't do that while fighting! It ruins the mood!\r\n", ch);
		return;
	}
	if (GET_POS(victim) == POS_FIGHTING)
	{
		send_to_char("You have to wait until your mate finishes fighting!\r\n", ch);
		return;
	}
	if (GET_POS(ch) < POS_RESTING)
	{
		send_to_char("You can't do that now!\r\n", ch);
		return;
	}
	if(PREG(ch) == OFF) {
		send_to_char("Sorry, you have to turn mating on to be able to mate.\r\n", ch);
		return;
	}
	if(PREG(victim) == OFF) {
		send_to_char("Sorry, they have turned mating off.\r\n", ch);
		return;
	}
	/* Routine Checks Performed */
	act("You ask $N if $E wishes to have a child with you.\r\n", TRUE, ch, 0, victim, TO_CHAR);
	act("$n asks if you want to have a child with $S.\r\n", TRUE, ch, 0, victim, TO_VICT);
	PREG(ch) = ASKING;
	/* Players involved are informed, female is set to ASKING */
}

/* For Men - Agree */
ACMD(do_agree)
{
	struct char_data *victim;
one_argument(argument, arg);
		if(!*arg) { /* Break up with noone? */
			send_to_char("Whom do you want to mate with?\r\n", ch);
			return;
		}
		else if(!(victim = get_char_room_vis(ch, arg))) {
			/* Are they here? No! */
			send_to_char(NOPERSON, ch);
			return;
		}
		else if(victim == ch) { /* Break up with yourself? */
			send_to_char("You can't agree to mate with yourself!\r\n", ch);
			return;
		}
		if(crashcheck_alpha(victim, ch) == 1)
		{
			return;
		}
		if (GET_POS(ch) == POS_FIGHTING)
		{
		send_to_char("You can't do that while fighting! It ruins the mood!\r\n", ch);
		return;
		}
		if (GET_POS(victim) == POS_FIGHTING)
		{
		send_to_char("You have to wait until your mate finishes fighting!\r\n", ch);
		return;
		}

	if(GET_SEX(victim) == SEX_MALE)
	{
		send_to_char("You need a female partner to mate with.\r\n", ch);
		return;
	}
	else if(GET_SEX(ch) == SEX_FEMALE)
	{
		send_to_char("Perhaps you should be asking to mate instead of agreeing?\r\n", ch);
		return;
	}
	if ((ROMANCE(ch) != 3) && (OUT_OF_WEDLOCK == FALSE))
	{
		send_to_char("Sorry, children may not be conceived out of wedlock here.\r\n", ch);
		return;
	}
	if (GET_POS(ch) < POS_RESTING)
	{
		send_to_char("You can't do that now!\r\n", ch);
		return;
	}
	if (PREG(victim) != -3)
	{
		send_to_char("But she's not asking to mate with you!\r\n", ch);
		return;
	}
	/* Routine Checks Performed */
	act("You agree to have a child with $N!\r\n", TRUE, ch, 0, victim, TO_CHAR);
	act("$n agrees to have a kid with you!\r\n", TRUE, ch, 0, victim, TO_VICT);
	act("$N announces that she's having $n's baby!\r\n", TRUE, ch, 0, victim, TO_NOTVICT);
	PREG(victim) = genpreg(); /* Generate a pregnancy time */
	/* All set. */
}

/* Deny fatherhood */

ACMD(do_deny)
{
		struct char_data *victim;
one_argument(argument, arg);
		if(!*arg) { /* Break up with noone? */
			send_to_char("Whom do you want to deny to mate with?\r\n", ch);
			return;
		}
		else if(!(victim = get_char_room_vis(ch, arg))) {
			/* Are they here? No! */
			send_to_char(NOPERSON, ch);
			return;
		}
		else if(victim == ch) { /* Break up with yourself? */
			send_to_char("You can't mate with yourself anyway!\r\n", ch);
			return;
		}
		if(crashcheck_alpha(victim, ch) == 1)
		{
			return;
		}
		if (GET_POS(ch) == POS_FIGHTING)
		{
		send_to_char("You can't do that while fighting!\r\n", ch);
		return;
		}
		if (GET_POS(victim) == POS_FIGHTING)
		{
		send_to_char("You have to wait until your mate finishes fighting!\r\n", ch);
		return;
		}

	else if(GET_SEX(victim) == SEX_MALE)
	{
		send_to_char("You can only mate with females...\r\n", ch);
		return;
	}
	else if(GET_SEX(ch) == SEX_FEMALE)
	{
		send_to_char("Perhaps you should be asking to mate instead of denying?\r\n", ch);
		return;
	}
	if (PREG(victim) != -3)
	{
		send_to_char("But she's not asking to mate with you!\r\n", ch);
		return;
	}
	act("You inform $N that you don't wish to mate with her.\r\n", TRUE, ch, 0, victim, TO_CHAR);
	act("$n doesn't feel like mating just yet.\r\n", TRUE, ch, 0, victim, TO_VICT);
	PREG(victim) = -1; /* Inform & Reset */
}

/* Generates a pregnancy time */
int genpreg ()
{
 int time;
 int rand_time;
 time = (NINE_MONTHS);
 rand_time = dice(6, 6); /* Max = 36 (One more mudmonth) Min = 6 (Less than one MudWeek) */
 time = time + rand_time + 2;
 return time;
}

/* Certain late-pregnancy symptoms.. */
void symptoms(struct char_data *ch)
{
	int contract = 0;
	if ((PREG(ch) < (MONTHS_5)) && (PREG(ch) > 0))
	{
		/* She's past month 5 */
		int check = 0;
		check = dice(1, 20); /* Random Number, 1 - 20) */
		if (check > 15)
		{
			return;
		} /* No symptoms */
		if (check == 16)
		{
            act("You feel the baby kick! OW!\r\n", TRUE, ch, 0, 0, TO_CHAR);
			act("$n flinches in pain. Baby is kicking again!\r\n", TRUE, ch, 0, 0, TO_ROOM);
			GET_HIT(ch) = GET_HIT(ch) - 2;
			return;
		}
	    if (check == 19)
		{
            act("You feel the baby kick! OW!\r\n", TRUE, ch, 0, 0, TO_CHAR);
			act("$n flinches in pain. Baby is kicking again!\r\n", TRUE, ch, 0, 0, TO_ROOM);
			GET_HIT(ch) = GET_HIT(ch) - 1;
			return;
		}
		if (check == 20)
		{
			act("A wave of nausea washes over you, and you vomit.\r\n", TRUE, ch, 0, 0, TO_CHAR);
			act("$n suddenly turns very green, then stumbles into a corner and vomits up her breakfast.\r\n", TRUE, ch, 0, 0, TO_CHAR);
			gain_condition(ch, FULL, -2);
			gain_condition(ch, THIRST, -3); /* Stomach's slightly emptier */
			return;
		}
	}
	if ((PREG(ch) <= (MONTH_1) && (PREG(ch) > 6)))
	{
		/* Near Birth  */
		contract = dice(2, 3);
		if(contract >= 4)
		{
		    act("You double over as a contraction causes a wave of sheer pain to wash over your body!\r\n", TRUE, ch, 0, 0, TO_CHAR);
			act("$n groans and doubles over as a contraction shoots through her.\r\n", TRUE, ch, 0, 0, TO_ROOM);
			GET_HIT(ch) = GET_HIT(ch) - 2;
		}
	}
	if ((PREG(ch) <= 6) && (PREG(ch) > 0))
	{
		act("You scream as the pain from birthing burns in your blood...\r\n", TRUE, ch, 0, 0, TO_CHAR);
		act("$n screams loudly and howls in pain!\r\n", TRUE, ch, 0, 0, TO_ROOM);
	}
	if(PREG(ch) == 0)
	{
		/* Birthing */
		PREG(ch) = -1;
		send_to_all("A large, white stork flies high above you!\r\n");
		act("You are whisked away to a nearby hospital, and return moments later, carrying your new child!\r\n", TRUE, ch, 0, 0, TO_CHAR);
		act("$n is whisked away in an ambulance, and quickly returns, baby in hand.\r\n", TRUE, ch, 0, 0, TO_ROOM);
		GET_HIT(ch) = GET_HIT(ch) - 10;
		act("A cart labelled 'Adventurer's Academy' arrives, and two uniformed men take your child from you.\r\n", TRUE, ch, 0, 0, TO_CHAR);
		act("A cart labelled 'Adventurer's Academy' arrives, and two uniformed men take $n's child.\r\n", TRUE, ch, 0, 0, TO_ROOM);
		if (REWARD_ALLOWED == TRUE) /* Rewards? */
		{
			GET_MAX_HIT(ch) += HP_REWARD;
			GET_MAX_MANA(ch) += MP_REWARD;
			GET_STR(ch) += STR_REWARD; 
			GET_CON(ch) += CON_REWARD;
			GET_DEX(ch) += DEX_REWARD;
			GET_WIS(ch) += WIS_REWARD;
			GET_INT(ch) += INT_REWARD;
			affect_total(ch);
		}
	}
}

/* ABORT Command - MatingMod -- IMMORTAL LEVEL */
ACMD(do_abort)
{
	struct char_data *victim;
	if(GET_LEVEL(ch) < LVL_IMMORT)
	{
		send_to_char("Only Immortals can use this command!\r\n", ch);
	    return;
	}
	if(ABORT_ALLOWED != TRUE)
	{
		send_to_char("Sorry, abortions are not allowed here!\r\n", ch);
		return;
	}
	one_argument(argument, arg);
	if(!*arg) { /* Mate with noone? */
	send_to_char("Whose pregnancy do you want to abort?\r\n", ch);
	return;
	}
	else if(!(victim = get_char_room_vis(ch, arg))) {
	/* Are they here? No! */
	send_to_char(NOPERSON, ch);
	return;
	}
	if(PREG(victim) < 0)
	{
		sprintf(buf, "But %s isn't pregnant!\r\n", GET_NAME(victim));
		send_to_char(buf, ch);
		return;
	}
	if(PREG(ch) == MALE)
	{
		send_to_char("But men can't have babies!\r\n", ch);
		return;
	}
	if (crashcheck_alpha(victim, ch) == 1)
	{
		return;
	}
	/* All checks pass.. */
	if(victim == ch)
	{
	act("You makes a mystical gesture towards your abdomen.\r\nAfter a moment of pain, it shrinks back to normal.\r\n", TRUE, ch, 0, victim, TO_CHAR);
	act("$n makes a mystical gesture towards $N's abdomen.\r\nIt shrinks back to normal.\r\n", TRUE, ch, 0, victim, TO_NOTVICT);
	PREG(ch) = NOT_PREG;
	}
	else
	{
	act("You make a mystical gesture towards $N's abdomen.\r\nIt shrinks back to normal.\r\n", TRUE, ch, 0, victim, TO_CHAR);
	act("$n makes a mystical gesture towards your abdomen.\r\nAfter a moment of pain, it shrinks back to normal.\r\n", TRUE, ch, 0, victim, TO_VICT);
	act("$n makes a mystical gesture towards $N's abdomen.\r\nIt shrinks back to normal.\r\n", TRUE, ch, 0, victim, TO_NOTVICT);
	PREG(victim) = NOT_PREG;
	/* Done. */

	}
}

ACMD (mate_toggle) {
	/* Romance/Mating Toggle On/Off
	 * Precondition: Person must be single + not pregnant
	 * Postcondition: If the person wants to not be bothered with
	 * M/R-mod thingies, then this toggle will prevent that.
	 * If they did not and now want to be involved in the
	 * social scene, then now they can.
	 */
	if(ROMANCE(ch) > 0) {
		send_to_char("Sorry, you have to be single to turn mating off.\n", ch);
	}
	if( PREG(ch) > -1 ) {
		send_to_char("Sorry, you cannot turn Mating off while pregnant.\n", ch);
	}
	/* Both Conditions pass.. Check + Set! */
	if(ROMANCE(ch) == 0) { ROMANCE(ch) = -1;  } // OFF
	else if(ROMANCE(ch) == -1) { ROMANCE(ch) = 0; } // Single
	if( (PREG(ch) == -1) || ( PREG(ch) == -2) ) {
		PREG(ch) = OFF; // OFF
	}
	else if(PREG(ch) == OFF) {
		if(GET_SEX(ch) == MALE) { PREG(ch) = -2; }
		else { PREG(ch) = -1; }
	}
} /* EO mate_toggle */

< END SECTION 1 >

< SECTION 2 >

/* Romance Module Defines */
#define SAME_SEX_ALLOWED FALSE /* True/False */

/* MatingMod Defines */
#define OUT_OF_WEDLOCK TRUE /* True/False */
#define REWARD_ALLOWED TRUE /* T/F */
#define HP_REWARD      10   /* All rewards are NUMERICAL */
#define MP_REWARD      10
#define STR_REWARD     0
#define CON_REWARD     1
#define INT_REWARD     0
#define WIS_REWARD     0
#define DEX_REWARD     0
#define ABORT_ALLOWED  TRUE /* T/F */
#define NINE_MONTHS    6000 /* 6000 realtime minutes TO GO*/
#define MONTHS_8        5333
#define MONTHS_7        4666 /* Note: These are MONTHS REMAINING */
#define MONTHS_6        4000
#define MONTHS_5        3333
#define MONTHS_4        2666
#define MONTHS_3        2000
#define MONTHS_2        1333
#define MONTH_1         666

< END SECTION 2 >